/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber;

import htsjdk.samtools.SAMSequenceDictionary;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.cmdline.programgroups.CoverageAnalysisProgramGroup;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.spark.LocusWalkerContext;
import org.broadinstitute.hellbender.engine.spark.LocusWalkerSpark;
import org.broadinstitute.hellbender.tools.copynumber.CollectAllelicCounts;
import org.broadinstitute.hellbender.tools.copynumber.arguments.CopyNumberArgumentValidationUtils;
import org.broadinstitute.hellbender.tools.copynumber.datacollection.AllelicCountCollector;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.Metadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.MetadataUtils;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.utils.Nucleotide;

@CommandLineProgramProperties(summary="Collects reference and alternate allele counts at specified sites", oneLineSummary="Collects reference and alternate allele counts at specified sites", programGroup=CoverageAnalysisProgramGroup.class)
public class CollectAllelicCountsSpark
extends LocusWalkerSpark {
    private static final long serialVersionUID = 1L;
    @Argument(doc="Output file for allelic counts.", fullName="output", shortName="O")
    private File outputAllelicCountsFile;
    @Argument(doc="Minimum base quality.  Base calls with lower quality will be filtered out of pileups.", fullName="minimum-base-quality", minValue=0.0, optional=true)
    private int minimumBaseQuality = 20;

    @Override
    public boolean emitEmptyLoci() {
        return true;
    }

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public boolean requiresIntervals() {
        return true;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        ArrayList<ReadFilter> readFilters = new ArrayList<ReadFilter>(super.getDefaultReadFilters());
        readFilters.addAll(CollectAllelicCounts.DEFAULT_ADDITIONAL_READ_FILTERS);
        return readFilters;
    }

    @Override
    protected void processAlignments(JavaRDD<LocusWalkerContext> rdd, JavaSparkContext ctx) {
        this.validateArguments();
        SampleLocatableMetadata metadata = (SampleLocatableMetadata)MetadataUtils.fromHeader(this.getHeaderForReads(), Metadata.Type.SAMPLE_LOCATABLE);
        SAMSequenceDictionary sequenceDictionary = this.getBestAvailableSequenceDictionary();
        if (!CopyNumberArgumentValidationUtils.isSameDictionary(metadata.getSequenceDictionary(), sequenceDictionary)) {
            this.logger.warn("Sequence dictionary in BAM does not match the master sequence dictionary.");
        }
        Broadcast sampleMetadataBroadcast = ctx.broadcast((Object)metadata);
        AllelicCountCollector finalAllelicCountCollector = (AllelicCountCollector)rdd.mapPartitions(CollectAllelicCountsSpark.distributedCount((Broadcast<SampleLocatableMetadata>)sampleMetadataBroadcast, this.minimumBaseQuality)).reduce((Function2 & Serializable)(a1, a2) -> CollectAllelicCountsSpark.combineAllelicCountCollectors(a1, a2, (SampleLocatableMetadata)sampleMetadataBroadcast.getValue()));
        this.logger.info(String.format("Writing allelic counts to %s...", this.outputAllelicCountsFile.getAbsolutePath()));
        finalAllelicCountCollector.getAllelicCounts().write(this.outputAllelicCountsFile);
        this.logger.info(String.format("%s complete.", this.getClass().getSimpleName()));
    }

    private void validateArguments() {
        CopyNumberArgumentValidationUtils.validateOutputFiles(this.outputAllelicCountsFile);
    }

    private static FlatMapFunction<Iterator<LocusWalkerContext>, AllelicCountCollector> distributedCount(Broadcast<SampleLocatableMetadata> sampleMetadataBroadcast, int minimumBaseQuality) {
        return (FlatMapFunction & Serializable)contextIterator -> {
            AllelicCountCollector result = new AllelicCountCollector((SampleLocatableMetadata)sampleMetadataBroadcast.getValue());
            contextIterator.forEachRemaining(ctx -> {
                byte refAsByte = ctx.getReferenceContext().getBase();
                result.collectAtLocus(Nucleotide.decode(refAsByte), ctx.getAlignmentContext().getBasePileup(), ctx.getAlignmentContext().getLocation(), minimumBaseQuality);
            });
            return Collections.singletonList(result).iterator();
        };
    }

    private static AllelicCountCollector combineAllelicCountCollectors(AllelicCountCollector allelicCountCollector1, AllelicCountCollector allelicCountCollector2, SampleLocatableMetadata sampleMetadata) {
        return AllelicCountCollector.combine(allelicCountCollector1, allelicCountCollector2, sampleMetadata);
    }
}

