/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.OverlapDetector;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.WorkflowOutput;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.CoverageAnalysisProgramGroup;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.MappingQualityReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.copynumber.arguments.CopyNumberArgumentValidationUtils;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.SimpleCountCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.Metadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.MetadataUtils;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.SimpleCount;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@CommandLineProgramProperties(summary="Collects read counts at specified intervals", oneLineSummary="Collects read counts at specified intervals", programGroup=CoverageAnalysisProgramGroup.class)
@DocumentedFeature
@WorkflowProperties
public final class CollectReadCounts
extends ReadWalker {
    private static final int DEFAULT_MINIMUM_MAPPING_QUALITY = 30;
    public static final String FORMAT_LONG_NAME = "format";
    @Argument(doc="Output file for read counts.", fullName="output", shortName="O")
    @WorkflowOutput
    private File outputCountsFile = null;
    @Argument(doc="Output file format.", fullName="format", optional=true)
    private Format format = Format.HDF5;
    private SampleLocatableMetadata metadata;
    private List<SimpleInterval> intervals;
    private String currentContig = null;
    private CachedOverlapDetector<SimpleInterval> intervalCachedOverlapDetector;
    private Multiset<SimpleInterval> intervalMultiset;

    @Override
    public boolean requiresIntervals() {
        return true;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        ArrayList<ReadFilter> readFilters = new ArrayList<ReadFilter>(super.getDefaultReadFilters());
        readFilters.add(ReadFilterLibrary.MAPPED);
        readFilters.add(ReadFilterLibrary.NON_ZERO_REFERENCE_LENGTH_ALIGNMENT);
        readFilters.add(ReadFilterLibrary.NOT_DUPLICATE);
        readFilters.add(new MappingQualityReadFilter(30));
        return readFilters;
    }

    @Override
    public void onTraversalStart() {
        this.validateArguments();
        this.metadata = (SampleLocatableMetadata)MetadataUtils.fromHeader(this.getHeaderForReads(), Metadata.Type.SAMPLE_LOCATABLE);
        SAMSequenceDictionary sequenceDictionary = this.getBestAvailableSequenceDictionary();
        if (!CopyNumberArgumentValidationUtils.isSameDictionary(this.metadata.getSequenceDictionary(), sequenceDictionary)) {
            this.logger.warn("Sequence dictionary in BAM does not match the master sequence dictionary.");
        }
        this.intervals = this.intervalArgumentCollection.getIntervals(sequenceDictionary);
        this.intervalMultiset = HashMultiset.create((int)this.intervals.size());
        this.logger.info("Collecting read counts...");
    }

    private void validateArguments() {
        CopyNumberArgumentValidationUtils.validateIntervalArgumentCollection(this.intervalArgumentCollection);
        CopyNumberArgumentValidationUtils.validateOutputFiles(this.outputCountsFile);
    }

    @Override
    public void apply(GATKRead read, ReferenceContext referenceContext, FeatureContext featureContext) {
        SimpleInterval overlappingInterval;
        if (this.currentContig == null || !read.getContig().equals(this.currentContig)) {
            this.currentContig = read.getContig();
            List intervalsOnCurrentContig = this.intervals.stream().filter(i -> i.getContig().equals(this.currentContig)).collect(Collectors.toList());
            this.intervalCachedOverlapDetector = new CachedOverlapDetector(intervalsOnCurrentContig);
        }
        if ((overlappingInterval = this.intervalCachedOverlapDetector.getOverlap(new SimpleInterval(read.getContig(), read.getStart(), read.getStart()))) == null) {
            return;
        }
        this.intervalMultiset.add((Object)overlappingInterval);
    }

    @Override
    public Object onTraversalSuccess() {
        this.logger.info(String.format("Writing read counts to %s...", this.outputCountsFile.getAbsolutePath()));
        SimpleCountCollection readCounts = new SimpleCountCollection(this.metadata, (List<SimpleCount>)ImmutableList.copyOf(this.intervals.stream().map(i -> new SimpleCount((SimpleInterval)i, this.intervalMultiset.count(i))).iterator()));
        if (this.format == Format.HDF5) {
            readCounts.writeHDF5(this.outputCountsFile);
        } else {
            readCounts.write(this.outputCountsFile);
        }
        this.logger.info(String.format("%s complete.", this.getClass().getSimpleName()));
        return null;
    }

    private final class CachedOverlapDetector<T extends Locatable> {
        private final OverlapDetector<T> overlapDetector;
        private T cachedResult;

        CachedOverlapDetector(List<T> intervals) {
            Utils.nonEmpty(intervals);
            this.overlapDetector = OverlapDetector.create(intervals);
            Utils.validateArg(intervals.stream().noneMatch(i -> this.overlapDetector.getOverlaps(i).size() > 1), "Input intervals may not be overlapping.");
            this.cachedResult = (Locatable)intervals.get(0);
        }

        T getOverlap(Locatable locatable) {
            if (IntervalUtils.overlaps(this.cachedResult, locatable)) {
                return this.cachedResult;
            }
            Set overlaps = this.overlapDetector.getOverlaps(locatable);
            if (overlaps.size() > 1) {
                throw new GATKException.ShouldNeverReachHereException("Intervals should be non-overlapping, so at most one interval should intersect with the start of a read.");
            }
            Locatable firstOverlap = overlaps.stream().findFirst().orElse(null);
            if (firstOverlap != null) {
                this.cachedResult = firstOverlap;
            }
            return (T)firstOverlap;
        }
    }

    public static enum Format {
        TSV,
        HDF5;

    }
}

