/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber;

import java.io.File;
import org.apache.commons.math3.linear.RealMatrix;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hdf5.HDF5File;
import org.broadinstitute.hdf5.HDF5Library;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.cmdline.programgroups.CopyNumberProgramGroup;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.copynumber.arguments.CopyNumberArgumentValidationUtils;
import org.broadinstitute.hellbender.tools.copynumber.denoising.HDF5SVDReadCountPanelOfNormals;
import org.broadinstitute.hellbender.tools.copynumber.denoising.SVDDenoisedCopyRatioResult;
import org.broadinstitute.hellbender.tools.copynumber.denoising.SVDDenoisingUtils;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AnnotatedIntervalCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.SimpleCountCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.annotation.CopyNumberAnnotations;

@CommandLineProgramProperties(summary="Denoises read counts to produce denoised copy ratios", oneLineSummary="Denoises read counts to produce denoised copy ratios", programGroup=CopyNumberProgramGroup.class)
@DocumentedFeature
public final class DenoiseReadCounts
extends CommandLineProgram {
    @Argument(doc="Input TSV or HDF5 file containing integer read counts in genomic intervals for a single case sample (output of CollectReadCounts).", fullName="input", shortName="I")
    private File inputReadCountFile;
    @Argument(doc="Input HDF5 file containing the panel of normals (output of CreateReadCountPanelOfNormals).", fullName="count-panel-of-normals", optional=true)
    private File inputPanelOfNormalsFile = null;
    @Argument(doc="Input file containing annotations for GC content in genomic intervals (output of AnnotateIntervals).  Intervals must be identical to and in the same order as those in the input read-counts file.  If a panel of normals is provided, this input will be ignored.", fullName="annotated-intervals", optional=true)
    private File inputAnnotatedIntervalsFile = null;
    @Argument(doc="Output file for standardized copy ratios.  GC-bias correction will be performed if annotations for GC content are provided.", fullName="standardized-copy-ratios")
    private File outputStandardizedCopyRatiosFile;
    @Argument(doc="Output file for denoised copy ratios.", fullName="denoised-copy-ratios")
    private File outputDenoisedCopyRatiosFile;
    @Argument(doc="Number of eigensamples to use for denoising.  If not specified or if the number of eigensamples available in the panel of normals is smaller than this, all eigensamples will be used.", fullName="number-of-eigensamples", minValue=0.0, optional=true)
    private Integer numEigensamplesRequested = null;

    @Override
    protected Object doWork() {
        if (!new HDF5Library().load(null)) {
            throw new UserException.HardwareFeatureException("Cannot load the required HDF5 library. HDF5 is currently supported on x86-64 architecture and Linux or OSX systems.");
        }
        this.validateArguments();
        this.logger.info(String.format("Reading read-counts file (%s)...", this.inputReadCountFile));
        SimpleCountCollection readCounts = SimpleCountCollection.read(this.inputReadCountFile);
        if (this.inputPanelOfNormalsFile != null) {
            try (HDF5File hdf5PanelOfNormalsFile = new HDF5File(this.inputPanelOfNormalsFile);){
                int numEigensamples;
                HDF5SVDReadCountPanelOfNormals panelOfNormals = HDF5SVDReadCountPanelOfNormals.read(hdf5PanelOfNormalsFile);
                if (this.inputAnnotatedIntervalsFile != null) {
                    this.logger.warn("Panel of normals was provided; ignoring input GC-content annotations...");
                }
                int n = numEigensamples = this.numEigensamplesRequested == null ? panelOfNormals.getNumEigensamples() : Math.min(panelOfNormals.getNumEigensamples(), this.numEigensamplesRequested);
                if (this.numEigensamplesRequested != null && numEigensamples < this.numEigensamplesRequested) {
                    this.logger.warn(String.format("%d eigensamples were requested but only %d are available in the panel of normals...", this.numEigensamplesRequested, numEigensamples));
                }
                SVDDenoisedCopyRatioResult denoisedCopyRatioResult = panelOfNormals.denoise(readCounts, numEigensamples);
                this.writeResult(denoisedCopyRatioResult);
            }
        } else {
            double[] intervalGCContent;
            AnnotatedIntervalCollection annotatedIntervals = CopyNumberArgumentValidationUtils.validateAnnotatedIntervals(this.inputAnnotatedIntervalsFile, readCounts, this.logger);
            double[] dArray = intervalGCContent = annotatedIntervals == null ? null : annotatedIntervals.getRecords().stream().mapToDouble(i -> i.getAnnotationMap().getValue(CopyNumberAnnotations.GC_CONTENT)).toArray();
            if (intervalGCContent == null) {
                this.logger.warn("Neither a panel of normals nor GC-content annotations were provided, so only standardization will be performed...");
            }
            RealMatrix standardizedCopyRatioValues = SVDDenoisingUtils.preprocessAndStandardizeSample(readCounts.getCounts(), intervalGCContent);
            SVDDenoisedCopyRatioResult standardizedResult = new SVDDenoisedCopyRatioResult((SampleLocatableMetadata)readCounts.getMetadata(), readCounts.getIntervals(), standardizedCopyRatioValues, standardizedCopyRatioValues);
            this.writeResult(standardizedResult);
        }
        this.logger.info(String.format("%s complete.", this.getClass().getSimpleName()));
        return null;
    }

    private void validateArguments() {
        CopyNumberArgumentValidationUtils.validateInputs(this.inputReadCountFile, this.inputPanelOfNormalsFile, this.inputAnnotatedIntervalsFile);
        CopyNumberArgumentValidationUtils.validateOutputFiles(this.outputStandardizedCopyRatiosFile, this.outputStandardizedCopyRatiosFile);
    }

    private void writeResult(SVDDenoisedCopyRatioResult result) {
        this.logger.info(String.format("Writing standardized and denoised copy ratios to %s and %s...", this.outputStandardizedCopyRatiosFile.getAbsolutePath(), this.outputDenoisedCopyRatiosFile.getAbsolutePath()));
        result.write(this.outputStandardizedCopyRatiosFile, this.outputDenoisedCopyRatiosFile);
    }
}

