/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.cmdline.argumentcollections.IntervalArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.OptionalIntervalArgumentCollection;
import org.broadinstitute.hellbender.cmdline.programgroups.CopyNumberProgramGroup;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.copynumber.GermlineCNVCaller;
import org.broadinstitute.hellbender.tools.copynumber.arguments.CopyNumberArgumentValidationUtils;
import org.broadinstitute.hellbender.tools.copynumber.arguments.GermlineContigPloidyHybridADVIArgumentCollection;
import org.broadinstitute.hellbender.tools.copynumber.arguments.GermlineContigPloidyModelArgumentCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.CoveragePerContigCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.SimpleIntervalCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.LocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.CoveragePerContig;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.SimpleCount;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.io.Resource;
import org.broadinstitute.hellbender.utils.python.PythonScriptExecutor;

@CommandLineProgramProperties(summary="Determines the baseline contig ploidy for germline samples given counts data", oneLineSummary="Determines the baseline contig ploidy for germline samples given counts data", programGroup=CopyNumberProgramGroup.class)
@DocumentedFeature
public final class DetermineGermlineContigPloidy
extends CommandLineProgram {
    public static final String COHORT_DETERMINE_PLOIDY_AND_DEPTH_PYTHON_SCRIPT = "cohort_determine_ploidy_and_depth.py";
    public static final String CASE_DETERMINE_PLOIDY_AND_DEPTH_PYTHON_SCRIPT = "case_determine_ploidy_and_depth.py";
    public static final String INPUT_MODEL_INTERVAL_FILE = "interval_list.tsv";
    public static final String MODEL_PATH_SUFFIX = "-model";
    public static final String CALLS_PATH_SUFFIX = "-calls";
    public static final String CONTIG_PLOIDY_PRIORS_FILE_LONG_NAME = "contig-ploidy-priors";
    @Argument(doc="Input paths for read-count files containing integer read counts in genomic intervals for all samples.  All intervals specified via -L/-XL must be contained; if none are specified, then intervals must be identical and in the same order for all samples.  If read-count files are given by Google Cloud Storage paths, have the extension .counts.tsv or .counts.tsv.gz, and have been indexed by IndexFeatureFile, only the specified intervals will be queried and streamed; this can reduce disk usage by avoiding the complete localization of all read-count files.", fullName="input", shortName="I", minElements=1)
    private List<String> inputReadCountPaths = new ArrayList<String>();
    @Argument(doc="Input file specifying contig-ploidy priors.  If only a single sample is specified, this input should not be provided.  If multiple samples are specified, this input is required.", fullName="contig-ploidy-priors", optional=true)
    private File inputContigPloidyPriorsFile;
    @Argument(doc="Input ploidy-model directory.  If only a single sample is specified, this input is required.  If multiple samples are specified, this input should not be provided.", fullName="model", optional=true)
    private File inputModelDir;
    @Argument(doc="Prefix for output filenames.", fullName="output-prefix")
    private String outputPrefix;
    @Argument(doc="Output directory.  This will be created if it does not exist.", fullName="output", shortName="O")
    private File outputDir;
    @ArgumentCollection
    protected IntervalArgumentCollection intervalArgumentCollection = new OptionalIntervalArgumentCollection();
    @Advanced
    @ArgumentCollection
    private GermlineContigPloidyModelArgumentCollection germlineContigPloidyModelArgumentCollection = new GermlineContigPloidyModelArgumentCollection();
    @Advanced
    @ArgumentCollection
    private GermlineContigPloidyHybridADVIArgumentCollection germlineContigPloidyHybridADVIArgumentCollection = new GermlineContigPloidyHybridADVIArgumentCollection();
    private RunMode runMode;
    private SimpleIntervalCollection specifiedIntervals;
    private File specifiedIntervalsFile;

    @Override
    protected void onStartup() {
        PythonScriptExecutor.checkPythonEnvironmentForPackage("gcnvkernel");
    }

    @Override
    protected Object doWork() {
        boolean intervalListContainsMultipleContigs;
        this.validateArguments();
        this.setModeAndResolveIntervals();
        boolean bl = intervalListContainsMultipleContigs = this.specifiedIntervals.getRecords().stream().map(SimpleInterval::getContig).collect(Collectors.toSet()).size() > 1;
        if (!intervalListContainsMultipleContigs) {
            this.logger.warn("The interval list only contains a single contig! Inference of the ploidy states will belimited to what is provided in contig-ploidy prior table, i.e. the ploidy state with highest value of prior will be chosen");
        }
        this.specifiedIntervalsFile = IOUtils.createTempFile("intervals", ".tsv");
        this.specifiedIntervals.write(this.specifiedIntervalsFile);
        File samplesByCoveragePerContigFile = IOUtils.createTempFile("samples-by-coverage-per-contig", ".tsv");
        this.writeSamplesByCoveragePerContig(samplesByCoveragePerContigFile);
        boolean pythonReturnCode = this.executeDeterminePloidyAndDepthPythonScript(samplesByCoveragePerContigFile, this.specifiedIntervalsFile);
        if (!pythonReturnCode) {
            throw new UserException("Python return code was non-zero.");
        }
        this.logger.info(String.format("%s complete.", this.getClass().getSimpleName()));
        return null;
    }

    private void validateArguments() {
        this.germlineContigPloidyModelArgumentCollection.validate();
        this.germlineContigPloidyHybridADVIArgumentCollection.validate();
        Utils.validateArg(this.inputReadCountPaths.size() == new HashSet<String>(this.inputReadCountPaths).size(), "List of input read-count files cannot contain duplicates.");
        this.inputReadCountPaths.forEach(xva$0 -> CopyNumberArgumentValidationUtils.validateInputs(xva$0));
        CopyNumberArgumentValidationUtils.validateInputs(this.inputContigPloidyPriorsFile, this.inputModelDir);
        Utils.nonEmpty(this.outputPrefix);
        CopyNumberArgumentValidationUtils.validateAndPrepareOutputDirectories(this.outputDir);
    }

    private void setModeAndResolveIntervals() {
        if (this.inputModelDir != null) {
            this.runMode = RunMode.CASE;
            this.logger.info("A contig-ploidy model was provided, running in case mode...");
            if (this.inputContigPloidyPriorsFile != null) {
                throw new UserException.BadInput("Invalid combination of inputs: Running in case mode, but contig-ploidy priors were provided.");
            }
            if (this.intervalArgumentCollection.intervalsSpecified()) {
                throw new UserException.BadInput("Invalid combination of inputs: Running in CASE mode, but intervals were provided.");
            }
            this.specifiedIntervalsFile = new File(this.inputModelDir, INPUT_MODEL_INTERVAL_FILE);
            CopyNumberArgumentValidationUtils.validateInputs(this.specifiedIntervalsFile);
            this.specifiedIntervals = new SimpleIntervalCollection(this.specifiedIntervalsFile);
        } else {
            this.runMode = RunMode.COHORT;
            this.logger.info("No contig-ploidy model was provided, running in cohort mode...");
            Utils.validateArg(this.inputReadCountPaths.size() > 1, "At least two samples must be provided in COHORT mode.");
            if (this.inputContigPloidyPriorsFile == null) {
                throw new UserException.BadInput("Contig-ploidy priors must be provided in cohort mode.");
            }
            String firstReadCountPath = this.inputReadCountPaths.get(0);
            this.specifiedIntervals = CopyNumberArgumentValidationUtils.resolveIntervals(firstReadCountPath, this.intervalArgumentCollection, this.logger);
        }
    }

    private void writeSamplesByCoveragePerContig(File samplesByCoveragePerContigFile) {
        this.logger.info("Validating and aggregating coverage per contig from input read-count files...");
        List<String> contigs = this.specifiedIntervals.getRecords().stream().map(SimpleInterval::getContig).distinct().collect(Collectors.toList());
        List<CoveragePerContig> coveragePerContigs = CopyNumberArgumentValidationUtils.streamOfSubsettedAndValidatedReadCounts(this.inputReadCountPaths, this.specifiedIntervals, this.logger).map(subsetReadCounts -> new CoveragePerContig(((SampleLocatableMetadata)subsetReadCounts.getMetadata()).getSampleName(), subsetReadCounts.getRecords().stream().collect(Collectors.groupingBy(SimpleCount::getContig, LinkedHashMap::new, Collectors.summingInt(SimpleCount::getCount))))).collect(Collectors.toList());
        new CoveragePerContigCollection((LocatableMetadata)this.specifiedIntervals.getMetadata(), coveragePerContigs, contigs).write(samplesByCoveragePerContigFile);
    }

    private boolean executeDeterminePloidyAndDepthPythonScript(File samplesByCoveragePerContigFile, File intervalsFile) {
        String script;
        PythonScriptExecutor executor = new PythonScriptExecutor(true);
        String outputDirArg = CopyNumberArgumentValidationUtils.addTrailingSlashIfNecessary(this.outputDir.getAbsolutePath());
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList("--sample_coverage_metadata=" + CopyNumberArgumentValidationUtils.getCanonicalPath(samplesByCoveragePerContigFile), "--output_calls_path=" + CopyNumberArgumentValidationUtils.getCanonicalPath(outputDirArg + this.outputPrefix + CALLS_PATH_SUFFIX)));
        arguments.addAll(this.germlineContigPloidyModelArgumentCollection.generatePythonArguments(this.runMode));
        arguments.addAll(this.germlineContigPloidyHybridADVIArgumentCollection.generatePythonArguments());
        if (this.runMode == RunMode.COHORT) {
            script = COHORT_DETERMINE_PLOIDY_AND_DEPTH_PYTHON_SCRIPT;
            arguments.add("--interval_list=" + CopyNumberArgumentValidationUtils.getCanonicalPath(intervalsFile));
            arguments.add("--contig_ploidy_prior_table=" + CopyNumberArgumentValidationUtils.getCanonicalPath(this.inputContigPloidyPriorsFile));
            arguments.add("--output_model_path=" + CopyNumberArgumentValidationUtils.getCanonicalPath(outputDirArg + this.outputPrefix + MODEL_PATH_SUFFIX));
        } else {
            script = CASE_DETERMINE_PLOIDY_AND_DEPTH_PYTHON_SCRIPT;
            arguments.add("--input_model_path=" + CopyNumberArgumentValidationUtils.getCanonicalPath(this.inputModelDir));
        }
        return executor.executeScript(new Resource(script, GermlineCNVCaller.class), null, arguments);
    }

    public static enum RunMode {
        COHORT,
        CASE;

    }
}

