/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.cmdline.argumentcollections.IntervalArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.OptionalIntervalArgumentCollection;
import org.broadinstitute.hellbender.cmdline.programgroups.CopyNumberProgramGroup;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.copynumber.arguments.CopyNumberArgumentValidationUtils;
import org.broadinstitute.hellbender.tools.copynumber.arguments.GermlineCNVHybridADVIArgumentCollection;
import org.broadinstitute.hellbender.tools.copynumber.arguments.GermlineCallingArgumentCollection;
import org.broadinstitute.hellbender.tools.copynumber.arguments.GermlineDenoisingModelArgumentCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AnnotatedIntervalCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.SimpleIntervalCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.io.Resource;
import org.broadinstitute.hellbender.utils.python.PythonScriptExecutor;
import org.broadinstitute.hellbender.utils.runtime.ProcessOutput;

@CommandLineProgramProperties(summary="Calls copy-number variants in germline samples given their counts and the output of DetermineGermlineContigPloidy", oneLineSummary="Calls copy-number variants in germline samples given their counts and the output of DetermineGermlineContigPloidy", programGroup=CopyNumberProgramGroup.class)
@DocumentedFeature
public final class GermlineCNVCaller
extends CommandLineProgram {
    public static final String COHORT_DENOISING_CALLING_PYTHON_SCRIPT = "cohort_denoising_calling.py";
    public static final String CASE_SAMPLE_CALLING_PYTHON_SCRIPT = "case_denoising_calling.py";
    public static final String INPUT_MODEL_INTERVAL_FILE = "interval_list.tsv";
    public static final String MODEL_PATH_SUFFIX = "-model";
    public static final String CALLS_PATH_SUFFIX = "-calls";
    public static final String TRACKING_PATH_SUFFIX = "-tracking";
    public static final String CONTIG_PLOIDY_CALLS_DIRECTORY_LONG_NAME = "contig-ploidy-calls";
    public static final String RUN_MODE_LONG_NAME = "run-mode";
    private static final int STARTING_SEED = 1984;
    private static final int DIVERGED_INFERENCE_EXIT_CODE = 239;
    @Argument(doc="Input paths for read-count files containing integer read counts in genomic intervals for all samples.  All intervals specified via -L/-XL must be contained; if none are specified, then intervals must be identical and in the same order for all samples.  If read-count files are given by Google Cloud Storage paths, have the extension .counts.tsv or .counts.tsv.gz, and have been indexed by IndexFeatureFile, only the specified intervals will be queried and streamed; this can reduce disk usage by avoiding the complete localization of all read-count files.", fullName="input", shortName="I", minElements=1)
    private List<String> inputReadCountPaths = new ArrayList<String>();
    @Argument(doc="Tool run-mode.", fullName="run-mode")
    private RunMode runMode;
    @Argument(doc="Input contig-ploidy calls directory (output of DetermineGermlineContigPloidy).", fullName="contig-ploidy-calls")
    private File inputContigPloidyCallsDir;
    @Argument(doc="Input denoising-model directory. In COHORT mode, this argument is optional; if provided,a new model will be built using this input model to initialize. In CASE mode, this argument is required and the denoising model parameters are set to this input model.", fullName="model", optional=true)
    private File inputModelDir = null;
    @Argument(doc="Input annotated-intervals file containing annotations for GC content in genomic intervals (output of AnnotateIntervals).  All intervals specified via -L must be contained.  This input should not be provided if an input denoising-model directory is given (the latter already contains the annotated-interval file).", fullName="annotated-intervals", optional=true)
    private File inputAnnotatedIntervalsFile = null;
    @Argument(doc="Prefix for output filenames.", fullName="output-prefix")
    private String outputPrefix;
    @Argument(doc="Output directory.  This will be created if it does not exist.", fullName="output", shortName="O")
    private File outputDir;
    @ArgumentCollection
    protected IntervalArgumentCollection intervalArgumentCollection = new OptionalIntervalArgumentCollection();
    @Advanced
    @ArgumentCollection
    private GermlineDenoisingModelArgumentCollection germlineDenoisingModelArgumentCollection = new GermlineDenoisingModelArgumentCollection();
    @Advanced
    @ArgumentCollection
    private GermlineCallingArgumentCollection germlineCallingArgumentCollection = new GermlineCallingArgumentCollection();
    @Advanced
    @ArgumentCollection
    private GermlineCNVHybridADVIArgumentCollection germlineCNVHybridADVIArgumentCollection = new GermlineCNVHybridADVIArgumentCollection();
    private SimpleIntervalCollection specifiedIntervals;
    private File specifiedIntervalsFile;

    @Override
    protected void onStartup() {
        PythonScriptExecutor.checkPythonEnvironmentForPackage("gcnvkernel");
    }

    @Override
    protected Object doWork() {
        this.validateArguments();
        this.resolveIntervals();
        List<File> intervalSubsetReadCountFiles = this.writeIntervalSubsetReadCountFiles();
        String script = this.runMode == RunMode.COHORT ? COHORT_DENOISING_CALLING_PYTHON_SCRIPT : CASE_SAMPLE_CALLING_PYTHON_SCRIPT;
        PythonScriptExecutor executor = new PythonScriptExecutor(true);
        ProcessOutput pythonProcessOutput = executor.executeScriptAndGetOutput(new Resource(script, GermlineCNVCaller.class), null, this.composePythonArguments(intervalSubsetReadCountFiles, 1984));
        if (pythonProcessOutput.getExitValue() != 0) {
            if (pythonProcessOutput.getExitValue() == 239) {
                Random generator = new Random(1984L);
                int nextGCNVSeed = generator.nextInt();
                this.logger.info("The inference failed to converge and will be restarted once with a different random seed.");
                pythonProcessOutput = executor.executeScriptAndGetOutput(new Resource(script, GermlineCNVCaller.class), null, this.composePythonArguments(intervalSubsetReadCountFiles, nextGCNVSeed));
            } else {
                throw executor.getScriptException(executor.getExceptionMessageFromScriptError(pythonProcessOutput));
            }
        }
        if (pythonProcessOutput.getExitValue() != 0) {
            if (pythonProcessOutput.getExitValue() == 239) {
                this.logger.info("The inference failed to converge twice. We suggest checking if input count or karyotype values or other inputs are abnormal (an example of abnormality is a count file containing mostly zeros).");
            }
            throw executor.getScriptException(executor.getExceptionMessageFromScriptError(pythonProcessOutput));
        }
        this.logger.info(String.format("%s complete.", this.getClass().getSimpleName()));
        return null;
    }

    private void validateArguments() {
        this.germlineCallingArgumentCollection.validate();
        this.germlineDenoisingModelArgumentCollection.validate();
        this.germlineCNVHybridADVIArgumentCollection.validate();
        Utils.validateArg(this.inputReadCountPaths.size() == new HashSet<String>(this.inputReadCountPaths).size(), "List of input read-count file paths cannot contain duplicates.");
        this.inputReadCountPaths.forEach(xva$0 -> CopyNumberArgumentValidationUtils.validateInputs(xva$0));
        CopyNumberArgumentValidationUtils.validateInputs(this.inputContigPloidyCallsDir, this.inputModelDir, this.inputAnnotatedIntervalsFile);
        Utils.nonEmpty(this.outputPrefix);
        CopyNumberArgumentValidationUtils.validateAndPrepareOutputDirectories(this.outputDir);
    }

    private void resolveIntervals() {
        if (this.inputModelDir != null) {
            this.specifiedIntervalsFile = new File(this.inputModelDir, INPUT_MODEL_INTERVAL_FILE);
            CopyNumberArgumentValidationUtils.validateInputs(this.specifiedIntervalsFile);
            this.specifiedIntervals = new SimpleIntervalCollection(this.specifiedIntervalsFile);
        } else {
            String firstReadCountPath = this.inputReadCountPaths.get(0);
            this.specifiedIntervals = CopyNumberArgumentValidationUtils.resolveIntervals(firstReadCountPath, this.intervalArgumentCollection, this.logger);
            this.specifiedIntervalsFile = IOUtils.createTempFile("intervals", ".tsv");
            AnnotatedIntervalCollection subsetAnnotatedIntervals = CopyNumberArgumentValidationUtils.validateAnnotatedIntervalsSubset(this.inputAnnotatedIntervalsFile, this.specifiedIntervals, this.logger);
            if (subsetAnnotatedIntervals != null) {
                this.logger.info("GC-content annotations for intervals found; explicit GC-bias correction will be performed...");
                subsetAnnotatedIntervals.write(this.specifiedIntervalsFile);
            } else {
                this.logger.info("No GC-content annotations for intervals found; explicit GC-bias correction will not be performed...");
                this.specifiedIntervals.write(this.specifiedIntervalsFile);
            }
        }
        if (this.runMode.equals((Object)RunMode.COHORT)) {
            this.logger.info("Running the tool in COHORT mode...");
            Utils.validateArg(this.inputReadCountPaths.size() > 1, "At least two samples must be provided in COHORT mode.");
            if (this.inputModelDir != null) {
                this.logger.info("(advanced feature) A denoising-model directory is provided in COHORT mode; using the model for initialization and ignoring specified and/or annotated intervals.");
            }
        } else {
            this.logger.info("Running the tool in CASE mode...");
            Utils.validateArg(this.inputModelDir != null, "An input denoising-model directory must be provided in CASE mode.");
            if (this.intervalArgumentCollection.intervalsSpecified()) {
                throw new UserException.BadInput("Invalid combination of inputs: Running in CASE mode, but intervals were provided.");
            }
            if (this.inputAnnotatedIntervalsFile != null) {
                throw new UserException.BadInput("Invalid combination of inputs: Running in CASE mode,but annotated intervals were provided.");
            }
        }
    }

    private List<File> writeIntervalSubsetReadCountFiles() {
        this.logger.info("Validating and aggregating data from input read-count files...");
        ArrayList<File> intervalSubsetReadCountFiles = new ArrayList<File>(this.inputReadCountPaths.size());
        CopyNumberArgumentValidationUtils.streamOfSubsettedAndValidatedReadCounts(this.inputReadCountPaths, this.specifiedIntervals, this.logger).forEach(subsetReadCounts -> {
            File intervalSubsetReadCountFile = IOUtils.createTempFile(((SampleLocatableMetadata)subsetReadCounts.getMetadata()).getSampleName(), ".tsv");
            subsetReadCounts.write(intervalSubsetReadCountFile);
            intervalSubsetReadCountFiles.add(intervalSubsetReadCountFile);
        });
        return intervalSubsetReadCountFiles;
    }

    private List<String> composePythonArguments(List<File> intervalSubsetReadCountFiles, int randomSeed) {
        String outputDirArg = CopyNumberArgumentValidationUtils.addTrailingSlashIfNecessary(this.outputDir.getAbsolutePath());
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList("--ploidy_calls_path=" + CopyNumberArgumentValidationUtils.getCanonicalPath(this.inputContigPloidyCallsDir), "--output_calls_path=" + CopyNumberArgumentValidationUtils.getCanonicalPath(outputDirArg + this.outputPrefix + CALLS_PATH_SUFFIX), "--output_tracking_path=" + CopyNumberArgumentValidationUtils.getCanonicalPath(outputDirArg + this.outputPrefix + TRACKING_PATH_SUFFIX)));
        if (this.inputModelDir != null) {
            arguments.add("--input_model_path=" + CopyNumberArgumentValidationUtils.getCanonicalPath(this.inputModelDir));
        }
        arguments.add(String.format("--random_seed=%d", randomSeed));
        if (this.runMode == RunMode.COHORT) {
            arguments.add("--modeling_interval_list=" + CopyNumberArgumentValidationUtils.getCanonicalPath(this.specifiedIntervalsFile));
            arguments.add("--output_model_path=" + CopyNumberArgumentValidationUtils.getCanonicalPath(outputDirArg + this.outputPrefix + MODEL_PATH_SUFFIX));
            if (this.inputAnnotatedIntervalsFile != null) {
                arguments.add("--enable_explicit_gc_bias_modeling=True");
            } else {
                arguments.add("--enable_explicit_gc_bias_modeling=False");
            }
        }
        arguments.add("--read_count_tsv_files");
        arguments.addAll(intervalSubsetReadCountFiles.stream().map(CopyNumberArgumentValidationUtils::getCanonicalPath).collect(Collectors.toList()));
        arguments.addAll(this.germlineDenoisingModelArgumentCollection.generatePythonArguments(this.runMode));
        arguments.addAll(this.germlineCallingArgumentCollection.generatePythonArguments(this.runMode));
        arguments.addAll(this.germlineCNVHybridADVIArgumentCollection.generatePythonArguments());
        return arguments;
    }

    public static enum RunMode {
        COHORT,
        CASE;

    }
}

