/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber;

import com.google.common.collect.ImmutableSet;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.OverlapDetector;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.math3.special.Beta;
import org.apache.commons.math3.util.FastMath;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.cmdline.programgroups.CopyNumberProgramGroup;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.copynumber.arguments.CopyNumberArgumentValidationUtils;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractRecordCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AlleleFractionSegmentCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AllelicCountCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.CopyRatioCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.CopyRatioSegmentCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.LegacySegmentCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.ModeledSegmentCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.MultidimensionalSegmentCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.AllelicCount;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.CopyRatio;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.CopyRatioSegment;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.LegacySegment;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.MultidimensionalSegment;
import org.broadinstitute.hellbender.tools.copynumber.models.AlleleFractionPrior;
import org.broadinstitute.hellbender.tools.copynumber.models.MultidimensionalModeller;
import org.broadinstitute.hellbender.tools.copynumber.segmentation.AlleleFractionKernelSegmenter;
import org.broadinstitute.hellbender.tools.copynumber.segmentation.CopyRatioKernelSegmenter;
import org.broadinstitute.hellbender.tools.copynumber.segmentation.MultidimensionalKernelSegmenter;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

@CommandLineProgramProperties(summary="Models segmented copy ratios from denoised read counts and segmented minor-allele fractions from allelic counts", oneLineSummary="Models segmented copy ratios from denoised read counts and segmented minor-allele fractions from allelic counts", programGroup=CopyNumberProgramGroup.class)
@DocumentedFeature
public final class ModelSegments
extends CommandLineProgram {
    public static final String HET_ALLELIC_COUNTS_FILE_SUFFIX = ".hets.tsv";
    public static final String NORMAL_HET_ALLELIC_COUNTS_FILE_SUFFIX = ".hets.normal.tsv";
    public static final String SEGMENTS_FILE_SUFFIX = ".seg";
    public static final String BEGIN_FIT_FILE_TAG = ".modelBegin";
    public static final String FINAL_FIT_FILE_TAG = ".modelFinal";
    public static final String COPY_RATIO_MODEL_PARAMETER_FILE_SUFFIX = ".cr.param";
    public static final String ALLELE_FRACTION_MODEL_PARAMETER_FILE_SUFFIX = ".af.param";
    public static final String COPY_RATIO_SEGMENTS_FOR_CALLER_FILE_SUFFIX = ".cr.seg";
    public static final String COPY_RATIO_LEGACY_SEGMENTS_FILE_SUFFIX = ".cr.igv.seg";
    public static final String ALLELE_FRACTION_LEGACY_SEGMENTS_FILE_SUFFIX = ".af.igv.seg";
    public static final String MINIMUM_TOTAL_ALLELE_COUNT_CASE_LONG_NAME = "minimum-total-allele-count-case";
    public static final String MINIMUM_TOTAL_ALLELE_COUNT_NORMAL_LONG_NAME = "minimum-total-allele-count-normal";
    public static final String GENOTYPING_HOMOZYGOUS_LOG_RATIO_THRESHOLD_LONG_NAME = "genotyping-homozygous-log-ratio-threshold";
    public static final String GENOTYPING_BASE_ERROR_RATE_LONG_NAME = "genotyping-base-error-rate";
    public static final String MAXIMUM_NUMBER_OF_SEGMENTS_PER_CHROMOSOME_LONG_NAME = "maximum-number-of-segments-per-chromosome";
    public static final String KERNEL_VARIANCE_COPY_RATIO_LONG_NAME = "kernel-variance-copy-ratio";
    public static final String KERNEL_VARIANCE_ALLELE_FRACTION_LONG_NAME = "kernel-variance-allele-fraction";
    public static final String KERNEL_SCALING_ALLELE_FRACTION_LONG_NAME = "kernel-scaling-allele-fraction";
    public static final String KERNEL_APPROXIMATION_DIMENSION_LONG_NAME = "kernel-approximation-dimension";
    public static final String WINDOW_SIZE_LONG_NAME = "window-size";
    public static final String NUMBER_OF_CHANGEPOINTS_PENALTY_FACTOR_LONG_NAME = "number-of-changepoints-penalty-factor";
    public static final String MINOR_ALLELE_FRACTION_PRIOR_ALPHA_LONG_NAME = "minor-allele-fraction-prior-alpha";
    public static final String NUMBER_OF_SAMPLES_COPY_RATIO_LONG_NAME = "number-of-samples-copy-ratio";
    public static final String NUMBER_OF_BURN_IN_SAMPLES_COPY_RATIO_LONG_NAME = "number-of-burn-in-samples-copy-ratio";
    public static final String NUMBER_OF_SAMPLES_ALLELE_FRACTION_LONG_NAME = "number-of-samples-allele-fraction";
    public static final String NUMBER_OF_BURN_IN_SAMPLES_ALLELE_FRACTION_LONG_NAME = "number-of-burn-in-samples-allele-fraction";
    public static final String SMOOTHING_CREDIBLE_INTERVAL_THRESHOLD_COPY_RATIO_LONG_NAME = "smoothing-credible-interval-threshold-copy-ratio";
    public static final String SMOOTHING_CREDIBLE_INTERVAL_THRESHOLD_ALLELE_FRACTION_LONG_NAME = "smoothing-credible-interval-threshold-allele-fraction";
    public static final String MAXIMUM_NUMBER_OF_SMOOTHING_ITERATIONS_LONG_NAME = "maximum-number-of-smoothing-iterations";
    public static final String NUMBER_OF_SMOOTHING_ITERATIONS_PER_FIT_LONG_NAME = "number-of-smoothing-iterations-per-fit";
    @Argument(doc="Input file containing denoised copy ratios (output of DenoiseReadCounts).", fullName="denoised-copy-ratios", optional=true)
    private File inputDenoisedCopyRatiosFile = null;
    @Argument(doc="Input file containing allelic counts (output of CollectAllelicCounts).", fullName="allelic-counts", optional=true)
    private File inputAllelicCountsFile = null;
    @Argument(doc="Input file containing allelic counts for a matched normal (output of CollectAllelicCounts).", fullName="normal-allelic-counts", optional=true)
    private File inputNormalAllelicCountsFile = null;
    @Argument(doc="Prefix for output filenames.", fullName="output-prefix")
    private String outputPrefix;
    @Argument(doc="Output directory.  This will be created if it does not exist.", fullName="output", shortName="O")
    private File outputDir;
    @Argument(doc="Minimum total count for filtering allelic counts in the case sample, if available.  The default value of zero is appropriate for matched-normal mode; increase to an appropriate value for case-only mode.", fullName="minimum-total-allele-count-case", minValue=0.0, optional=true)
    private int minTotalAlleleCountCase = 0;
    @Argument(doc="Minimum total count for filtering allelic counts in the matched-normal sample, if available.", fullName="minimum-total-allele-count-normal", minValue=0.0, optional=true)
    private int minTotalAlleleCountNormal = 30;
    @Argument(doc="Log-ratio threshold for genotyping and filtering homozygous allelic counts, if available.  Increasing this value will increase the number of sites assumed to be heterozygous for modeling.", fullName="genotyping-homozygous-log-ratio-threshold", optional=true)
    private double genotypingHomozygousLogRatioThreshold = -10.0;
    @Argument(doc="Maximum base-error rate for genotyping and filtering homozygous allelic counts, if available.  The likelihood for an allelic count to be generated from a homozygous site will be integrated from zero base-error rate up to this value.  Decreasing this value will increase the number of sites assumed to be heterozygous for modeling.", fullName="genotyping-base-error-rate", minValue=0.0, maxValue=1.0, optional=true)
    private double genotypingBaseErrorRate = 0.05;
    @Argument(doc="Maximum number of segments allowed per chromosome.", fullName="maximum-number-of-segments-per-chromosome", minValue=1.0, optional=true)
    private int maxNumSegmentsPerChromosome = 1000;
    @Argument(doc="Variance of Gaussian kernel for copy-ratio segmentation, if performed.  If zero, a linear kernel will be used.", fullName="kernel-variance-copy-ratio", minValue=0.0, optional=true)
    private double kernelVarianceCopyRatio = 0.0;
    @Argument(doc="Variance of Gaussian kernel for allele-fraction segmentation, if performed.  If zero, a linear kernel will be used.", fullName="kernel-variance-allele-fraction", minValue=0.0, optional=true)
    private double kernelVarianceAlleleFraction = 0.025;
    @Argument(doc="Relative scaling S of the kernel K_AF for allele-fraction segmentation to the kernel K_CR for copy-ratio segmentation.  If multidimensional segmentation is performed, the total kernel used will be K_CR + S * K_AF.", fullName="kernel-scaling-allele-fraction", minValue=0.0, optional=true)
    private double kernelScalingAlleleFraction = 1.0;
    @Argument(doc="Dimension of the kernel approximation.  A subsample containing this number of data points will be used to construct the approximation for each chromosome.  If the total number of data points in a chromosome is greater than this number, then all data points in the chromosome will be used.  Time complexity scales quadratically and space complexity scales linearly with this parameter.", fullName="kernel-approximation-dimension", minValue=1.0, optional=true)
    private int kernelApproximationDimension = 100;
    @Argument(doc="Window sizes to use for calculating local changepoint costs.  For each window size, the cost for each data point to be a changepoint will be calculated assuming that the point demarcates two adjacent segments of that size.  Including small (large) window sizes will increase sensitivity to small (large) events.  Duplicate values will be ignored.", fullName="window-size", minValue=1.0, optional=true)
    private List<Integer> windowSizes = new ArrayList<Integer>(Arrays.asList(8, 16, 32, 64, 128, 256));
    @Argument(doc="Factor A for the penalty on the number of changepoints per chromosome for segmentation.  Adds a penalty of the form A * C * [1 + log (N / C)], where C is the number of changepoints in the chromosome, to the cost function for each chromosome.  Must be non-negative.", fullName="number-of-changepoints-penalty-factor", minValue=0.0, optional=true)
    private double numChangepointsPenaltyFactor = 1.0;
    @Argument(doc="Alpha hyperparameter for the 4-parameter beta-distribution prior on segment minor-allele fraction. The prior for the minor-allele fraction f in each segment is assumed to be Beta(alpha, 1, 0, 1/2). Increasing this hyperparameter will reduce the effect of reference bias at the expense of sensitivity.", fullName="minor-allele-fraction-prior-alpha", optional=true, minValue=1.0)
    private double minorAlleleFractionPriorAlpha = 25.0;
    @Argument(doc="Total number of MCMC samples for copy-ratio model.", fullName="number-of-samples-copy-ratio", optional=true, minValue=1.0)
    private int numSamplesCopyRatio = 100;
    @Argument(doc="Number of burn-in samples to discard for copy-ratio model.", fullName="number-of-burn-in-samples-copy-ratio", optional=true, minValue=0.0)
    private int numBurnInCopyRatio = 50;
    @Argument(doc="Total number of MCMC samples for allele-fraction model.", fullName="number-of-samples-allele-fraction", optional=true, minValue=1.0)
    private int numSamplesAlleleFraction = 100;
    @Argument(doc="Number of burn-in samples to discard for allele-fraction model.", fullName="number-of-burn-in-samples-allele-fraction", optional=true, minValue=0.0)
    private int numBurnInAlleleFraction = 50;
    @Argument(doc="Number of 10% equal-tailed credible-interval widths to use for copy-ratio segmentation smoothing.", fullName="smoothing-credible-interval-threshold-copy-ratio", optional=true, minValue=0.0)
    private double smoothingCredibleIntervalThresholdCopyRatio = 2.0;
    @Argument(doc="Number of 10% equal-tailed credible-interval widths to use for allele-fraction segmentation smoothing.", fullName="smoothing-credible-interval-threshold-allele-fraction", optional=true, minValue=0.0)
    private double smoothingCredibleIntervalThresholdAlleleFraction = 2.0;
    @Argument(doc="Maximum number of iterations allowed for segmentation smoothing.", fullName="maximum-number-of-smoothing-iterations", optional=true, minValue=0.0)
    private int maxNumSmoothingIterations = 25;
    @Argument(doc="Number of segmentation-smoothing iterations per MCMC model refit. (Increasing this will decrease runtime, but the final number of segments may be higher. Setting this to 0 will completely disable model refitting between iterations.)", fullName="number-of-smoothing-iterations-per-fit", optional=true, minValue=0.0)
    private int numSmoothingIterationsPerFit = 0;

    @Override
    protected Object doWork() {
        MultidimensionalSegmentCollection multidimensionalSegments;
        this.validateArguments();
        CopyRatioCollection denoisedCopyRatios = this.readOptionalFileOrNull(this.inputDenoisedCopyRatiosFile, CopyRatioCollection::new);
        AllelicCountCollection allelicCounts = this.readOptionalFileOrNull(this.inputAllelicCountsFile, AllelicCountCollection::new);
        AllelicCountCollection normalAllelicCounts = this.readOptionalFileOrNull(this.inputNormalAllelicCountsFile, AllelicCountCollection::new);
        SampleLocatableMetadata metadata = this.getValidatedMetadata(denoisedCopyRatios, allelicCounts);
        AllelicCountCollection hetAllelicCounts = this.genotypeHets(metadata, denoisedCopyRatios, allelicCounts, normalAllelicCounts);
        if (denoisedCopyRatios == null) {
            denoisedCopyRatios = new CopyRatioCollection(metadata, Collections.emptyList());
        }
        if (!denoisedCopyRatios.getRecords().isEmpty() && hetAllelicCounts.getRecords().isEmpty()) {
            CopyRatioSegmentCollection copyRatioSegments = this.performCopyRatioSegmentation(denoisedCopyRatios);
            multidimensionalSegments = new MultidimensionalSegmentCollection((SampleLocatableMetadata)copyRatioSegments.getMetadata(), copyRatioSegments.getRecords().stream().map(s -> new MultidimensionalSegment(s.getInterval(), s.getNumPoints(), 0, s.getMeanLog2CopyRatio())).collect(Collectors.toList()));
        } else if (denoisedCopyRatios.getRecords().isEmpty() && !hetAllelicCounts.getRecords().isEmpty()) {
            AlleleFractionSegmentCollection alleleFractionSegments = this.performAlleleFractionSegmentation(hetAllelicCounts);
            multidimensionalSegments = new MultidimensionalSegmentCollection((SampleLocatableMetadata)alleleFractionSegments.getMetadata(), alleleFractionSegments.getRecords().stream().map(s -> new MultidimensionalSegment(s.getInterval(), 0, s.getNumPoints(), Double.NaN)).collect(Collectors.toList()));
        } else {
            multidimensionalSegments = new MultidimensionalKernelSegmenter(denoisedCopyRatios, hetAllelicCounts).findSegmentation(this.maxNumSegmentsPerChromosome, this.kernelVarianceCopyRatio, this.kernelVarianceAlleleFraction, this.kernelScalingAlleleFraction, this.kernelApproximationDimension, (List<Integer>)ImmutableSet.copyOf(this.windowSizes).asList(), this.numChangepointsPenaltyFactor, this.numChangepointsPenaltyFactor);
        }
        this.logger.info("Modeling available denoised copy ratios and heterozygous allelic counts...");
        AlleleFractionPrior alleleFractionPrior = new AlleleFractionPrior(this.minorAlleleFractionPriorAlpha);
        MultidimensionalModeller modeller = new MultidimensionalModeller(multidimensionalSegments, denoisedCopyRatios, hetAllelicCounts, alleleFractionPrior, this.numSamplesCopyRatio, this.numBurnInCopyRatio, this.numSamplesAlleleFraction, this.numBurnInAlleleFraction);
        this.writeModeledSegmentsAndParameterFiles(modeller, BEGIN_FIT_FILE_TAG);
        modeller.smoothSegments(this.maxNumSmoothingIterations, this.numSmoothingIterationsPerFit, this.smoothingCredibleIntervalThresholdCopyRatio, this.smoothingCredibleIntervalThresholdAlleleFraction);
        this.writeModeledSegmentsAndParameterFiles(modeller, FINAL_FIT_FILE_TAG);
        OverlapDetector<CopyRatio> copyRatioMidpointOverlapDetector = denoisedCopyRatios.getMidpointOverlapDetector();
        CopyRatioSegmentCollection copyRatioSegmentsFinal = new CopyRatioSegmentCollection((SampleLocatableMetadata)modeller.getModeledSegments().getMetadata(), modeller.getModeledSegments().getIntervals().stream().map(s -> new CopyRatioSegment((SimpleInterval)s, (List<CopyRatio>)new ArrayList<CopyRatio>(copyRatioMidpointOverlapDetector.getOverlaps((Locatable)s)))).collect(Collectors.toList()));
        this.writeSegments(copyRatioSegmentsFinal, COPY_RATIO_SEGMENTS_FOR_CALLER_FILE_SUFFIX);
        LegacySegmentCollection copyRatioLegacySegments = new LegacySegmentCollection(metadata, modeller.getModeledSegments().getRecords().stream().map(s -> new LegacySegment(metadata.getSampleName(), s.getInterval(), s.getNumPointsCopyRatio(), s.getLog2CopyRatioSimplePosteriorSummary().getDecile50())).collect(Collectors.toList()));
        LegacySegmentCollection alleleFractionLegacySegments = new LegacySegmentCollection(metadata, modeller.getModeledSegments().getRecords().stream().map(s -> new LegacySegment(metadata.getSampleName(), s.getInterval(), s.getNumPointsAlleleFraction(), s.getMinorAlleleFractionSimplePosteriorSummary().getDecile50())).collect(Collectors.toList()));
        this.writeSegments(copyRatioLegacySegments, COPY_RATIO_LEGACY_SEGMENTS_FILE_SUFFIX);
        this.writeSegments(alleleFractionLegacySegments, ALLELE_FRACTION_LEGACY_SEGMENTS_FILE_SUFFIX);
        this.logger.info(String.format("%s complete.", this.getClass().getSimpleName()));
        return null;
    }

    private void validateArguments() {
        Utils.validateArg(this.inputDenoisedCopyRatiosFile != null || this.inputAllelicCountsFile != null, "Must provide at least a denoised-copy-ratios file or an allelic-counts file.");
        Utils.validateArg(this.inputAllelicCountsFile != null || this.inputNormalAllelicCountsFile == null, "Must provide an allelic-counts file for the case sample to run in matched-normal mode.");
        CopyNumberArgumentValidationUtils.validateInputs(this.inputDenoisedCopyRatiosFile, this.inputAllelicCountsFile, this.inputNormalAllelicCountsFile);
        Utils.nonEmpty(this.outputPrefix);
        CopyNumberArgumentValidationUtils.validateAndPrepareOutputDirectories(this.outputDir);
        Utils.validateArg(this.numSamplesCopyRatio > this.numBurnInCopyRatio, "Number of copy-ratio samples must be greater than number of copy-ratio burn-in samples.");
        Utils.validateArg(this.numSamplesAlleleFraction > this.numBurnInAlleleFraction, "Number of allele-fraction samples must be greater than number of allele-fraction burn-in samples.");
    }

    private <T> T readOptionalFileOrNull(File file, Function<File, T> read) {
        if (file == null) {
            return null;
        }
        this.logger.info(String.format("Reading file (%s)...", file));
        return read.apply(file);
    }

    private SampleLocatableMetadata getValidatedMetadata(CopyRatioCollection denoisedCopyRatios, AllelicCountCollection allelicCounts) {
        Set metadataSet = Stream.of(denoisedCopyRatios, allelicCounts).filter(Objects::nonNull).map(AbstractRecordCollection::getMetadata).collect(Collectors.toSet());
        Utils.validateArg(metadataSet.size() == 1, "Metadata do not match for input case-sample files.");
        return (SampleLocatableMetadata)metadataSet.stream().findFirst().get();
    }

    private CopyRatioSegmentCollection performCopyRatioSegmentation(CopyRatioCollection denoisedCopyRatios) {
        this.logger.info("Starting segmentation of denoised copy ratios...");
        return new CopyRatioKernelSegmenter(denoisedCopyRatios).findSegmentation(this.maxNumSegmentsPerChromosome, this.kernelVarianceCopyRatio, this.kernelApproximationDimension, (List<Integer>)ImmutableSet.copyOf(this.windowSizes).asList(), this.numChangepointsPenaltyFactor, this.numChangepointsPenaltyFactor);
    }

    private AllelicCountCollection genotypeHets(SampleLocatableMetadata metadata, CopyRatioCollection denoisedCopyRatios, AllelicCountCollection allelicCounts, AllelicCountCollection normalAllelicCounts) {
        AllelicCountCollection hetAllelicCounts;
        if (allelicCounts == null) {
            return new AllelicCountCollection(metadata, Collections.emptyList());
        }
        this.logger.info("Genotyping heterozygous sites from available allelic counts...");
        AllelicCountCollection filteredAllelicCounts = allelicCounts;
        this.logger.info(String.format("Filtering allelic counts with total count less than %d...", this.minTotalAlleleCountCase));
        filteredAllelicCounts = new AllelicCountCollection(metadata, filteredAllelicCounts.getRecords().stream().filter(ac -> ac.getTotalReadCount() >= this.minTotalAlleleCountCase).collect(Collectors.toList()));
        this.logger.info(String.format("Retained %d / %d sites after filtering on total count...", filteredAllelicCounts.size(), allelicCounts.size()));
        if (denoisedCopyRatios != null) {
            this.logger.info("Filtering allelic-count sites not overlapping with copy-ratio intervals...");
            filteredAllelicCounts = new AllelicCountCollection(metadata, filteredAllelicCounts.getRecords().stream().filter(ac -> denoisedCopyRatios.getOverlapDetector().overlapsAny((Locatable)ac)).collect(Collectors.toList()));
            this.logger.info(String.format("Retained %d / %d sites after filtering on overlap with copy-ratio intervals...", filteredAllelicCounts.size(), allelicCounts.size()));
        }
        if (normalAllelicCounts == null) {
            this.logger.info("No matched normal was provided, not running in matched-normal mode...");
            this.logger.info("Performing binomial testing and filtering homozygous allelic counts...");
            hetAllelicCounts = new AllelicCountCollection(metadata, filteredAllelicCounts.getRecords().stream().filter(ac -> ModelSegments.calculateHomozygousLogRatio(ac, this.genotypingBaseErrorRate) < this.genotypingHomozygousLogRatioThreshold).collect(Collectors.toList()));
            this.logger.info(String.format("Retained %d / %d sites after testing for heterozygosity...", hetAllelicCounts.size(), allelicCounts.size()));
            File hetAllelicCountsFile = new File(this.outputDir, this.outputPrefix + HET_ALLELIC_COUNTS_FILE_SUFFIX);
            this.logger.info(String.format("Writing heterozygous allelic counts to %s...", hetAllelicCountsFile.getAbsolutePath()));
            hetAllelicCounts.write(hetAllelicCountsFile);
        } else {
            this.logger.info("Matched normal was provided, running in matched-normal mode...");
            this.logger.info("Performing binomial testing and filtering homozygous allelic counts in matched normal...");
            if (!normalAllelicCounts.getIntervals().equals(allelicCounts.getIntervals())) {
                throw new UserException.BadInput("Allelic-count sites in case sample and matched normal do not match. Run CollectAllelicCounts using the same interval list of sites for both samples.");
            }
            SampleLocatableMetadata normalMetadata = (SampleLocatableMetadata)normalAllelicCounts.getMetadata();
            if (!CopyNumberArgumentValidationUtils.isSameDictionary(normalMetadata.getSequenceDictionary(), metadata.getSequenceDictionary())) {
                this.logger.warn("Sequence dictionaries in allelic-count files do not match.");
            }
            this.logger.info(String.format("Filtering allelic counts in matched normal with total count less than %d...", this.minTotalAlleleCountNormal));
            AllelicCountCollection filteredNormalAllelicCounts = new AllelicCountCollection(normalMetadata, normalAllelicCounts.getRecords().stream().filter(ac -> ac.getTotalReadCount() >= this.minTotalAlleleCountNormal).collect(Collectors.toList()));
            this.logger.info(String.format("Retained %d / %d sites in matched normal after filtering on total count...", filteredNormalAllelicCounts.size(), normalAllelicCounts.size()));
            if (denoisedCopyRatios != null) {
                this.logger.info("Filtering allelic-count sites in matched normal not overlapping with copy-ratio intervals...");
                filteredNormalAllelicCounts = new AllelicCountCollection(normalMetadata, filteredNormalAllelicCounts.getRecords().stream().filter(ac -> denoisedCopyRatios.getOverlapDetector().overlapsAny((Locatable)ac)).collect(Collectors.toList()));
                this.logger.info(String.format("Retained %d / %d sites in matched normal after filtering on overlap with copy-ratio intervals...", filteredNormalAllelicCounts.size(), normalAllelicCounts.size()));
            }
            AllelicCountCollection hetNormalAllelicCounts = new AllelicCountCollection(normalMetadata, filteredNormalAllelicCounts.getRecords().stream().filter(ac -> ModelSegments.calculateHomozygousLogRatio(ac, this.genotypingBaseErrorRate) < this.genotypingHomozygousLogRatioThreshold).collect(Collectors.toList()));
            this.logger.info(String.format("Retained %d / %d sites in matched normal after testing for heterozygosity...", hetNormalAllelicCounts.size(), normalAllelicCounts.size()));
            File hetNormalAllelicCountsFile = new File(this.outputDir, this.outputPrefix + NORMAL_HET_ALLELIC_COUNTS_FILE_SUFFIX);
            this.logger.info(String.format("Writing heterozygous allelic counts for matched normal to %s...", hetNormalAllelicCountsFile.getAbsolutePath()));
            hetNormalAllelicCounts.write(hetNormalAllelicCountsFile);
            this.logger.info("Retrieving allelic counts at these sites in case sample...");
            hetAllelicCounts = new AllelicCountCollection(metadata, filteredAllelicCounts.getRecords().stream().filter(ac -> hetNormalAllelicCounts.getOverlapDetector().overlapsAny((Locatable)ac)).collect(Collectors.toList()));
            File hetAllelicCountsFile = new File(this.outputDir, this.outputPrefix + HET_ALLELIC_COUNTS_FILE_SUFFIX);
            this.logger.info(String.format("Writing allelic counts for case sample at heterozygous sites in matched normal to %s...", hetAllelicCountsFile.getAbsolutePath()));
            hetAllelicCounts.write(hetAllelicCountsFile);
        }
        return hetAllelicCounts;
    }

    private static double calculateHomozygousLogRatio(AllelicCount allelicCount, double genotypingBaseErrorRate) {
        int r = allelicCount.getRefReadCount();
        int n = allelicCount.getTotalReadCount();
        double betaAll = Beta.regularizedBeta((double)1.0, (double)(r + 1), (double)(n - r + 1));
        double betaError = Beta.regularizedBeta((double)genotypingBaseErrorRate, (double)(r + 1), (double)(n - r + 1));
        double betaOneMinusError = Beta.regularizedBeta((double)(1.0 - genotypingBaseErrorRate), (double)(r + 1), (double)(n - r + 1));
        double betaHom = betaError + betaAll - betaOneMinusError;
        double betaHet = betaOneMinusError - betaError;
        return FastMath.log((double)betaHom) - FastMath.log((double)betaHet);
    }

    private AlleleFractionSegmentCollection performAlleleFractionSegmentation(AllelicCountCollection hetAllelicCounts) {
        this.logger.info("Starting segmentation of heterozygous allelic counts...");
        return new AlleleFractionKernelSegmenter(hetAllelicCounts).findSegmentation(this.maxNumSegmentsPerChromosome, this.kernelVarianceAlleleFraction, this.kernelApproximationDimension, (List<Integer>)ImmutableSet.copyOf(this.windowSizes).asList(), this.numChangepointsPenaltyFactor, this.numChangepointsPenaltyFactor);
    }

    private void writeModeledSegmentsAndParameterFiles(MultidimensionalModeller modeller, String fileTag) {
        ModeledSegmentCollection modeledSegments = modeller.getModeledSegments();
        this.writeSegments(modeledSegments, fileTag + SEGMENTS_FILE_SUFFIX);
        File copyRatioParameterFile = new File(this.outputDir, this.outputPrefix + fileTag + COPY_RATIO_MODEL_PARAMETER_FILE_SUFFIX);
        File alleleFractionParameterFile = new File(this.outputDir, this.outputPrefix + fileTag + ALLELE_FRACTION_MODEL_PARAMETER_FILE_SUFFIX);
        modeller.writeModelParameterFiles(copyRatioParameterFile, alleleFractionParameterFile);
    }

    private void writeSegments(AbstractRecordCollection<?, ?> segments, String fileSuffix) {
        File segmentsFile = new File(this.outputDir, this.outputPrefix + fileSuffix);
        this.logger.info(String.format("Writing segments to %s...", segmentsFile.getAbsolutePath()));
        segments.write(segmentsFile);
    }
}

