/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.CopyNumberProgramGroup;
import org.broadinstitute.hellbender.engine.GATKTool;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.copynumber.arguments.CopyNumberArgumentValidationUtils;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractLocatableCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractRecordCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.BaselineCopyNumberCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.CopyNumberPosteriorDistributionCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.IntegerCopyNumberSegmentCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.LinearCopyRatioCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.NonLocatableDoubleCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.OverlappingIntegerCopyNumberSegmentCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.SimpleIntervalCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.LocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SimpleSampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.CopyNumberPosteriorDistribution;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.IntervalCopyNumberGenotypingData;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.LinearCopyRatio;
import org.broadinstitute.hellbender.tools.copynumber.gcnv.GermlineCNVIntervalVariantComposer;
import org.broadinstitute.hellbender.tools.copynumber.gcnv.GermlineCNVSegmentVariantComposer;
import org.broadinstitute.hellbender.tools.copynumber.gcnv.IntegerCopyNumberState;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.io.Resource;
import org.broadinstitute.hellbender.utils.python.PythonScriptExecutor;
import org.broadinstitute.hellbender.utils.reference.ReferenceUtils;

@CommandLineProgramProperties(summary="Postprocesses the output of GermlineCNVCaller and generates VCFs and denoised copy ratios", oneLineSummary="Postprocesses the output of GermlineCNVCaller and generates VCFs and denoised copy ratios", programGroup=CopyNumberProgramGroup.class)
@DocumentedFeature
public final class PostprocessGermlineCNVCalls
extends GATKTool {
    public static final String SEGMENT_GERMLINE_CNV_CALLS_PYTHON_SCRIPT = "segment_gcnv_calls.py";
    public static final String CALLS_SHARD_PATH_LONG_NAME = "calls-shard-path";
    public static final String MODEL_SHARD_PATH_LONG_NAME = "model-shard-path";
    public static final String CONTIG_PLOIDY_CALLS_LONG_NAME = "contig-ploidy-calls";
    public static final String SAMPLE_INDEX_LONG_NAME = "sample-index";
    public static final String OUTPUT_INTERVALS_VCF_LONG_NAME = "output-genotyped-intervals";
    public static final String OUTPUT_SEGMENTS_VCF_LONG_NAME = "output-genotyped-segments";
    public static final String OUTPUT_DENOISED_COPY_RATIOS_LONG_NAME = "output-denoised-copy-ratios";
    public static final String AUTOSOMAL_REF_COPY_NUMBER_LONG_NAME = "autosomal-ref-copy-number";
    public static final String ALLOSOMAL_CONTIG_LONG_NAME = "allosomal-contig";
    public static final String INPUT_INTERVALS_LONG_NAME = "input-intervals-vcf";
    public static final String CLUSTERED_FILE_LONG_NAME = "clustered-breakpoints";
    public static final String DUPLICATION_QS_THRESHOLD_LONG_NAME = "duplication-qs-threshold";
    public static final String HET_DEL_QS_THRESHOLD_LONG_NAME = "het-deletion-qs-threshold";
    public static final String HOM_DEL_QS_THRESHOLD_LONG_NAME = "hom-deletion-qs-threshold";
    public static final String SITE_FREQUENCY_THRESHOLD_LONG_NAME = "site-frequency-threshold";
    @Argument(doc="List of paths to GermlineCNVCaller call directories.", fullName="calls-shard-path", minElements=1)
    private List<File> inputUnsortedCallsShardPaths;
    @Argument(doc="List of paths to GermlineCNVCaller model directories.", fullName="model-shard-path", minElements=1)
    private List<File> inputUnsortedModelShardPaths;
    @Argument(doc="Path to contig-ploidy calls directory (output of DetermineGermlineContigPloidy).", fullName="contig-ploidy-calls")
    private File inputContigPloidyCallsPath;
    @Argument(doc="Sample index in the call-set (must be contained in all shards).", fullName="sample-index", minValue=0.0)
    private int sampleIndex;
    @Argument(doc="Reference copy-number on autosomal intervals.", fullName="autosomal-ref-copy-number", minValue=0.0)
    private int refAutosomalCopyNumber = 2;
    @Argument(doc="Contigs to treat as allosomal (i.e. choose their reference copy-number allele according to the sample karyotype).", fullName="allosomal-contig", optional=true)
    private List<String> allosomalContigList;
    @Argument(doc="Input VCF with combined intervals for all samples", fullName="input-intervals-vcf", optional=true)
    private File combinedIntervalsVCFFile = null;
    @Argument(doc="VCF with clustered breakpoints and copy number calls for all samples, can be generated with GATK JointGermlineCNVSegmentation tool", fullName="clustered-breakpoints", optional=true)
    private File clusteredBreakpointsVCFFile = null;
    @Argument(doc="Output intervals VCF file.", fullName="output-genotyped-intervals")
    private File outputIntervalsVCFFile;
    @Argument(doc="Output segments VCF file.", fullName="output-genotyped-segments")
    private File outputSegmentsVCFFile;
    @Argument(doc="Output denoised copy ratio file.", fullName="output-denoised-copy-ratios")
    private File outputDenoisedCopyRatioFile;
    @Argument(doc="Filter out heterozygous deletions with quality lower than this.", fullName="het-deletion-qs-threshold", optional=true, minValue=0.0)
    private int hetDelQSThreshold = 100;
    @Argument(doc="Filter out homozygous deletions with quality lower than this.", fullName="hom-deletion-qs-threshold", optional=true, minValue=0.0)
    private int homDelQSThreshold = 400;
    @Argument(doc="Filter out duplications with quality lower than this.", fullName="duplication-qs-threshold", optional=true, minValue=0.0)
    private int dupeQSThreshold = 50;
    @Argument(doc="Filter out variants with site frequency higher than this.", fullName="site-frequency-threshold", optional=true, minValue=0.0)
    private double siteFrequencyThreshold = 0.01;
    private List<SimpleIntervalCollection> sortedIntervalCollections;
    private SAMSequenceDictionary sequenceDictionary;
    private String sampleName;
    private int numShards;
    private IntegerCopyNumberState refAutosomalIntegerCopyNumberState;
    private Set<String> allosomalContigSet;
    private List<SimpleIntervalCollection> unsortedIntervalCollectionsFromCalls;
    private List<SimpleIntervalCollection> unsortedIntervalCollectionsFromModels;
    private List<File> sortedCallsShardPaths;
    private List<File> sortedModelShardPaths;

    @Override
    public void onStartup() {
        super.onStartup();
        PythonScriptExecutor.checkPythonEnvironmentForPackage("gcnvkernel");
    }

    @Override
    public SAMSequenceDictionary getBestAvailableSequenceDictionary() {
        if (this.getMasterSequenceDictionary() != null) {
            this.sequenceDictionary = this.getMasterSequenceDictionary();
            return this.sequenceDictionary;
        }
        List<SimpleIntervalCollection> unsortedIntervalCollectionsFromCalls = PostprocessGermlineCNVCalls.getIntervalCollectionsFromPaths(this.inputUnsortedCallsShardPaths);
        List<SimpleIntervalCollection> unsortedIntervalCollectionsFromModels = PostprocessGermlineCNVCalls.getIntervalCollectionsFromPaths(this.inputUnsortedModelShardPaths);
        this.sequenceDictionary = ((LocatableMetadata)unsortedIntervalCollectionsFromCalls.get(0).getMetadata()).getSequenceDictionary();
        Utils.validateArg(unsortedIntervalCollectionsFromCalls.stream().map(AbstractRecordCollection::getMetadata).map(LocatableMetadata::getSequenceDictionary).allMatch(shardSAMSequenceDictionary -> shardSAMSequenceDictionary.equals((Object)this.sequenceDictionary)), "The SAM sequence dictionary is not the same for all of the call shards.");
        Utils.validateArg(unsortedIntervalCollectionsFromModels.stream().map(AbstractRecordCollection::getMetadata).map(LocatableMetadata::getSequenceDictionary).allMatch(shardSAMSequenceDictionary -> shardSAMSequenceDictionary.equals((Object)this.sequenceDictionary)), "The SAM sequence dictionary is either not the same for all of the model shards, or is different from the SAM sequence dictionary of calls shards.");
        return this.sequenceDictionary;
    }

    @Override
    public void onTraversalStart() {
        this.validateArguments();
        this.numShards = this.inputUnsortedCallsShardPaths.size();
        this.sequenceDictionary = this.getBestAvailableSequenceDictionary();
        List<Integer> sortedCallShardsOrder = AbstractLocatableCollection.getShardedCollectionSortOrder(this.getUnsortedIntervalCollectionsFromCalls());
        List<Integer> sortedModelShardsOrder = AbstractLocatableCollection.getShardedCollectionSortOrder(this.getUnsortedIntervalCollectionsFromModels());
        this.sortedCallsShardPaths = sortedCallShardsOrder.stream().map(this.inputUnsortedCallsShardPaths::get).collect(Collectors.toList());
        this.sortedModelShardPaths = sortedModelShardsOrder.stream().map(this.inputUnsortedModelShardPaths::get).collect(Collectors.toList());
        List sortedIntervalCollectionsFromCalls = sortedCallShardsOrder.stream().map(this.getUnsortedIntervalCollectionsFromCalls()::get).collect(Collectors.toList());
        List sortedIntervalCollectionsFromModels = sortedModelShardsOrder.stream().map(this.getUnsortedIntervalCollectionsFromModels()::get).collect(Collectors.toList());
        Utils.validateArg(sortedIntervalCollectionsFromCalls.equals(sortedIntervalCollectionsFromModels), "The interval lists found in model and call shards do not match. Make sure that the calls and model paths are provided in matching order.");
        this.sortedIntervalCollections = sortedIntervalCollectionsFromCalls;
        this.checkForSingletonInterval(this.sortedIntervalCollections);
        Set allContigs = this.sequenceDictionary.getSequences().stream().map(SAMSequenceRecord::getSequenceName).collect(Collectors.toSet());
        this.allosomalContigSet = new HashSet<String>(this.allosomalContigList);
        if (this.allosomalContigSet.isEmpty()) {
            this.logger.warn(String.format("Allosomal contigs were not specified; setting ref copy-number allele to (%d) for all intervals.", this.refAutosomalCopyNumber));
        } else {
            Utils.validateArg(allContigs.containsAll(this.allosomalContigSet), String.format("The specified allosomal contigs must be contained in the SAM sequence dictionary of the call-set (specified allosomal contigs: %s, all contigs: %s)", this.allosomalContigSet.stream().collect(Collectors.joining(", ", "[", "]")), allContigs.stream().collect(Collectors.joining(", ", "[", "]"))));
        }
        this.sampleName = this.getShardSampleName(0);
        Utils.validate(IntStream.range(1, this.numShards).mapToObj(this::getShardSampleName).allMatch(shardSampleName -> shardSampleName.equals(this.sampleName)), "The sample name is not the same for all of the shards.");
        this.refAutosomalIntegerCopyNumberState = new IntegerCopyNumberState(this.refAutosomalCopyNumber);
    }

    private void validateArguments() {
        Utils.validateArg(this.inputUnsortedCallsShardPaths.size() == this.inputUnsortedModelShardPaths.size(), "The number of input call shards must match the number of input model shards.");
        this.inputUnsortedCallsShardPaths.forEach(xva$0 -> CopyNumberArgumentValidationUtils.validateInputs(xva$0));
        this.inputUnsortedModelShardPaths.forEach(xva$0 -> CopyNumberArgumentValidationUtils.validateInputs(xva$0));
        CopyNumberArgumentValidationUtils.validateInputs(this.inputContigPloidyCallsPath);
        CopyNumberArgumentValidationUtils.validateOutputFiles(this.outputIntervalsVCFFile, this.outputSegmentsVCFFile, this.outputDenoisedCopyRatioFile);
    }

    @Override
    public void traverse() {
    }

    @Override
    public Object onTraversalSuccess() {
        this.generateIntervalsVCFFileFromAllShards();
        this.generateSegmentsVCFFileFromAllShards();
        this.concatenateDenoisedCopyRatioFiles();
        this.logger.info(String.format("%s complete.", this.getClass().getSimpleName()));
        return null;
    }

    private void generateIntervalsVCFFileFromAllShards() {
        this.logger.info("Generating intervals VCF file...");
        VariantContextWriter intervalsVCFWriter = this.createVCFWriter(this.outputIntervalsVCFFile);
        GermlineCNVIntervalVariantComposer germlineCNVIntervalVariantComposer = new GermlineCNVIntervalVariantComposer(intervalsVCFWriter, this.sampleName, this.refAutosomalIntegerCopyNumberState, this.allosomalContigSet);
        germlineCNVIntervalVariantComposer.composeVariantContextHeader(this.sequenceDictionary, this.getDefaultToolVCFHeaderLines());
        this.logger.info(String.format("Writing intervals VCF file to %s...", this.outputIntervalsVCFFile.getAbsolutePath()));
        for (int shardIndex = 0; shardIndex < this.numShards; ++shardIndex) {
            this.logger.info(String.format("Analyzing shard %d / %d...", shardIndex + 1, this.numShards));
            germlineCNVIntervalVariantComposer.writeAll(this.getShardIntervalCopyNumberPosteriorData(shardIndex));
        }
        intervalsVCFWriter.close();
    }

    private void generateSegmentsVCFFileFromAllShards() {
        String sampleNameFromSegmentCollection;
        AbstractRecordCollection integerCopyNumberSegmentCollection;
        this.logger.info("Generating segments...");
        File pythonScriptOutputPath = IOUtils.createTempDir("gcnv-segmented-calls");
        boolean pythonScriptSucceeded = PostprocessGermlineCNVCalls.executeSegmentGermlineCNVCallsPythonScript(this.sampleIndex, this.inputContigPloidyCallsPath, this.sortedCallsShardPaths, this.sortedModelShardPaths, this.combinedIntervalsVCFFile, this.clusteredBreakpointsVCFFile, pythonScriptOutputPath);
        if (!pythonScriptSucceeded) {
            throw new UserException("Python return code was non-zero.");
        }
        this.logger.info("Parsing Python output...");
        File copyNumberSegmentsFile = PostprocessGermlineCNVCalls.getCopyNumberSegmentsFile(pythonScriptOutputPath, this.sampleIndex);
        if (this.clusteredBreakpointsVCFFile == null) {
            integerCopyNumberSegmentCollection = new IntegerCopyNumberSegmentCollection(copyNumberSegmentsFile);
            sampleNameFromSegmentCollection = ((SampleLocatableMetadata)integerCopyNumberSegmentCollection.getMetadata()).getSampleName();
        } else {
            integerCopyNumberSegmentCollection = new OverlappingIntegerCopyNumberSegmentCollection(copyNumberSegmentsFile);
            sampleNameFromSegmentCollection = ((SampleLocatableMetadata)integerCopyNumberSegmentCollection.getMetadata()).getSampleName();
        }
        Utils.validate(sampleNameFromSegmentCollection.equals(this.sampleName), String.format("Sample name found in the header of copy-number segments file is different from the expected sample name (found: %s, expected: %s).", sampleNameFromSegmentCollection, this.sampleName));
        List records = integerCopyNumberSegmentCollection.getRecords();
        this.logger.info(String.format("Writing segments VCF file to %s...", this.outputSegmentsVCFFile.getAbsolutePath()));
        VariantContextWriter segmentsVCFWriter = this.createVCFWriter(this.outputSegmentsVCFFile);
        GermlineCNVSegmentVariantComposer germlineCNVSegmentVariantComposer = new GermlineCNVSegmentVariantComposer(segmentsVCFWriter, this.sampleName, this.refAutosomalIntegerCopyNumberState, this.allosomalContigSet, this.referenceArguments.getReferenceSpecifier() == null ? null : ReferenceUtils.createReferenceReader(this.referenceArguments.getReferenceSpecifier()), this.dupeQSThreshold, this.hetDelQSThreshold, this.homDelQSThreshold, this.siteFrequencyThreshold, this.clusteredBreakpointsVCFFile);
        germlineCNVSegmentVariantComposer.composeVariantContextHeader(this.sequenceDictionary, this.getDefaultToolVCFHeaderLines());
        germlineCNVSegmentVariantComposer.writeAll(records);
        segmentsVCFWriter.close();
    }

    private void concatenateDenoisedCopyRatioFiles() {
        this.logger.info("Generating denoised copy ratios...");
        ArrayList<SimpleInterval> concatenatedIntervalList = new ArrayList<SimpleInterval>();
        ArrayList concatenatedDenoisedCopyRatioRecordsList = new ArrayList();
        for (int shardIndex = 0; shardIndex < this.numShards; ++shardIndex) {
            File shardRootDirectory = this.sortedCallsShardPaths.get(shardIndex);
            File denoisedCopyRatioFile = PostprocessGermlineCNVCalls.getSampleDenoisedCopyRatioFile(shardRootDirectory, this.sampleIndex);
            NonLocatableDoubleCollection shardNonLocatableLinearCopyRatioCollectionForShard = new NonLocatableDoubleCollection(denoisedCopyRatioFile);
            List<SimpleInterval> shardIntervals = this.sortedIntervalCollections.get(shardIndex).getIntervals();
            String sampleNameFromDenoisedCopyRatioFile = ((SampleMetadata)shardNonLocatableLinearCopyRatioCollectionForShard.getMetadata()).getSampleName();
            Utils.validate(sampleNameFromDenoisedCopyRatioFile.equals(this.sampleName), String.format("Sample name found in the header of denoised copy ratio file for shard %d is different from the expected sample name (found: %s, expected: %s).", shardIndex, sampleNameFromDenoisedCopyRatioFile, this.sampleName));
            List shardDenoisedCopyRatioRecords = shardNonLocatableLinearCopyRatioCollectionForShard.getRecords();
            Utils.validate(shardIntervals.size() == shardDenoisedCopyRatioRecords.size(), String.format("The number of entries in denoised copy ratio file for shard %d does not match the number of entries in the shard interval list (copy ratio list size: %d, interval list size: %d)", shardIndex, shardDenoisedCopyRatioRecords.size(), shardIntervals.size()));
            concatenatedIntervalList.addAll(shardIntervals);
            concatenatedDenoisedCopyRatioRecordsList.addAll(shardDenoisedCopyRatioRecords);
        }
        List<LinearCopyRatio> linearCopyRatioList = IntStream.range(0, concatenatedIntervalList.size()).mapToObj(intervalIndex -> new LinearCopyRatio((SimpleInterval)concatenatedIntervalList.get(intervalIndex), (Double)concatenatedDenoisedCopyRatioRecordsList.get(intervalIndex))).collect(Collectors.toList());
        SimpleSampleLocatableMetadata metadata = new SimpleSampleLocatableMetadata(this.sampleName, this.sequenceDictionary);
        LinearCopyRatioCollection linearCopyRatioCollection = new LinearCopyRatioCollection(metadata, linearCopyRatioList);
        this.logger.info(String.format("Writing denoised copy ratios to %s...", this.outputDenoisedCopyRatioFile.getAbsolutePath()));
        linearCopyRatioCollection.write(this.outputDenoisedCopyRatioFile);
    }

    private static List<SimpleIntervalCollection> getIntervalCollectionsFromPaths(List<File> shardsPathList) {
        return shardsPathList.stream().map(shardPath -> new SimpleIntervalCollection(PostprocessGermlineCNVCalls.getIntervalFileFromShardDirectory(shardPath))).collect(Collectors.toList());
    }

    private String getShardSampleName(int shardIndex) {
        File shardSampleNameTextFile = PostprocessGermlineCNVCalls.getSampleNameTextFile(this.sortedCallsShardPaths.get(shardIndex), this.sampleIndex);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(shardSampleNameTextFile));
            return reader.readLine();
        }
        catch (IOException ex) {
            throw new UserException.BadInput(String.format("Could not read the sample name text file at %s.", shardSampleNameTextFile.getAbsolutePath()));
        }
    }

    private List<IntervalCopyNumberGenotypingData> getShardIntervalCopyNumberPosteriorData(int shardIndex) {
        File shardRootDirectory = this.sortedCallsShardPaths.get(shardIndex);
        File sampleCopyNumberPosteriorFile = PostprocessGermlineCNVCalls.getSampleCopyNumberPosteriorFile(shardRootDirectory, this.sampleIndex);
        CopyNumberPosteriorDistributionCollection copyNumberPosteriorDistributionCollection = new CopyNumberPosteriorDistributionCollection(sampleCopyNumberPosteriorFile);
        String sampleNameFromCopyNumberPosteriorFile = ((SampleMetadata)copyNumberPosteriorDistributionCollection.getMetadata()).getSampleName();
        Utils.validate(sampleNameFromCopyNumberPosteriorFile.equals(this.sampleName), String.format("Sample name found in the header of copy-number posterior file for shard %d different from the expected sample name (found: %s, expected: %s).", shardIndex, sampleNameFromCopyNumberPosteriorFile, this.sampleName));
        File sampleBaselineCopyNumberFile = PostprocessGermlineCNVCalls.getSampleBaselineCopyNumberFile(shardRootDirectory, this.sampleIndex);
        BaselineCopyNumberCollection baselineCopyNumberCollection = new BaselineCopyNumberCollection(sampleBaselineCopyNumberFile);
        String sampleNameFromBaselineCopyNumberFile = ((SampleMetadata)baselineCopyNumberCollection.getMetadata()).getSampleName();
        Utils.validate(sampleNameFromBaselineCopyNumberFile.equals(this.sampleName), String.format("Sample name found in the header of baseline copy-number file for shard %d different from the expected sample name (found: %s, expected: %s).", shardIndex, sampleNameFromBaselineCopyNumberFile, this.sampleName));
        List<SimpleInterval> shardIntervals = this.sortedIntervalCollections.get(shardIndex).getIntervals();
        List copyNumberPosteriorDistributionList = copyNumberPosteriorDistributionCollection.getRecords();
        Utils.validate(shardIntervals.size() == copyNumberPosteriorDistributionList.size(), String.format("The number of entries in the copy-number posterior file for shard %d does not match the number of entries in the shard interval list (posterior list size: %d, interval list size: %d)", shardIndex, copyNumberPosteriorDistributionList.size(), shardIntervals.size()));
        List baselineCopyNumberList = baselineCopyNumberCollection.getRecords();
        Utils.validate(shardIntervals.size() == baselineCopyNumberList.size(), String.format("The number of entries in the baseline copy-number file for shard %d does not match the number of entries in the shard interval list (baseline copy-number list size: %d, interval list size: %d)", shardIndex, baselineCopyNumberList.size(), shardIntervals.size()));
        return IntStream.range(0, copyNumberPosteriorDistributionCollection.size()).mapToObj(intervalIndex -> new IntervalCopyNumberGenotypingData((SimpleInterval)shardIntervals.get(intervalIndex), (CopyNumberPosteriorDistribution)copyNumberPosteriorDistributionList.get(intervalIndex), (IntegerCopyNumberState)baselineCopyNumberList.get(intervalIndex))).collect(Collectors.toList());
    }

    private static File getSampleCopyNumberPosteriorFile(File callShardPath, int sampleIndex) {
        return Paths.get(callShardPath.getAbsolutePath(), "SAMPLE_" + sampleIndex, "log_q_c_tc.tsv").toFile();
    }

    private static File getSampleBaselineCopyNumberFile(File callShardPath, int sampleIndex) {
        return Paths.get(callShardPath.getAbsolutePath(), "SAMPLE_" + sampleIndex, "baseline_copy_number_t.tsv").toFile();
    }

    private static File getSampleNameTextFile(File callShardRootPath, int sampleIndex) {
        return Paths.get(callShardRootPath.getAbsolutePath(), "SAMPLE_" + sampleIndex, "sample_name.txt").toFile();
    }

    private static File getSampleDenoisedCopyRatioFile(File callShardPath, int sampleIndex) {
        return Paths.get(callShardPath.getAbsolutePath(), "SAMPLE_" + sampleIndex, "mu_denoised_copy_ratio_t.tsv").toFile();
    }

    private static File getIntervalFileFromShardDirectory(File shardPath) {
        return new File(shardPath, "interval_list.tsv");
    }

    private static boolean executeSegmentGermlineCNVCallsPythonScript(int sampleIndex, File contigPloidyCallsPath, List<File> sortedCallDirectories, List<File> sortedModelDirectories, File combinedIntervalsVCFFile, File clusteredBreakpointsVCFFile, File pythonScriptOutputPath) {
        try {
            Utils.nonNull(contigPloidyCallsPath);
            Utils.nonNull(sortedCallDirectories);
            Utils.nonNull(sortedModelDirectories);
            Utils.nonNull(pythonScriptOutputPath);
            sortedCallDirectories.forEach(Utils::nonNull);
            sortedModelDirectories.forEach(Utils::nonNull);
        }
        catch (IllegalArgumentException ex) {
            throw new GATKException.ShouldNeverReachHereException(ex);
        }
        PythonScriptExecutor executor = new PythonScriptExecutor(true);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--ploidy_calls_path");
        arguments.add(CopyNumberArgumentValidationUtils.getCanonicalPath(contigPloidyCallsPath));
        arguments.add("--model_shards");
        arguments.addAll(sortedModelDirectories.stream().map(CopyNumberArgumentValidationUtils::getCanonicalPath).collect(Collectors.toList()));
        arguments.add("--calls_shards");
        arguments.addAll(sortedCallDirectories.stream().map(CopyNumberArgumentValidationUtils::getCanonicalPath).collect(Collectors.toList()));
        arguments.add("--output_path");
        arguments.add(CopyNumberArgumentValidationUtils.getCanonicalPath(pythonScriptOutputPath));
        arguments.add("--sample_index");
        arguments.add(String.valueOf(sampleIndex));
        if (combinedIntervalsVCFFile != null) {
            arguments.add("--intervals_vcf");
            arguments.add(combinedIntervalsVCFFile.toString());
        }
        if (clusteredBreakpointsVCFFile != null) {
            arguments.add("--clustered_vcf");
            arguments.add(clusteredBreakpointsVCFFile.toString());
        }
        return executor.executeScript(new Resource(SEGMENT_GERMLINE_CNV_CALLS_PYTHON_SCRIPT, PostprocessGermlineCNVCalls.class), null, arguments);
    }

    private static File getCopyNumberSegmentsFile(File pythonSegmenterOutputPath, int sampleIndex) {
        return Paths.get(pythonSegmenterOutputPath.getAbsolutePath(), "SAMPLE_" + sampleIndex, "copy_number_segments.tsv").toFile();
    }

    private List<SimpleIntervalCollection> getUnsortedIntervalCollectionsFromCalls() {
        if (this.unsortedIntervalCollectionsFromCalls == null) {
            this.unsortedIntervalCollectionsFromCalls = PostprocessGermlineCNVCalls.getIntervalCollectionsFromPaths(this.inputUnsortedCallsShardPaths);
        }
        return this.unsortedIntervalCollectionsFromCalls;
    }

    private List<SimpleIntervalCollection> getUnsortedIntervalCollectionsFromModels() {
        if (this.unsortedIntervalCollectionsFromModels == null) {
            this.unsortedIntervalCollectionsFromModels = PostprocessGermlineCNVCalls.getIntervalCollectionsFromPaths(this.inputUnsortedModelShardPaths);
        }
        return this.unsortedIntervalCollectionsFromModels;
    }

    private void checkForSingletonInterval(List<SimpleIntervalCollection> intervalCollections) {
        intervalCollections.stream().flatMap(list -> list.getIntervals().stream()).collect(Collectors.groupingBy(SimpleInterval::getContig, Collectors.counting())).entrySet().stream().forEach(entry -> {
            if ((Long)entry.getValue() == 1L) {
                throw new IllegalArgumentException(String.format("Records contain a singleton interval on contig (%s). Please run FilterIntervals tool first.", entry.getKey()));
            }
        });
    }
}

