/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Locatable;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.math3.util.FastMath;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.GATKTool;
import org.broadinstitute.hellbender.engine.ReferenceDataSource;
import org.broadinstitute.hellbender.tools.copynumber.arguments.CopyNumberArgumentValidationUtils;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.Nucleotide;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import picard.cmdline.programgroups.IntervalsManipulationProgramGroup;

@CommandLineProgramProperties(summary="Prepares bins for coverage collection", oneLineSummary="Prepares bins for coverage collection", programGroup=IntervalsManipulationProgramGroup.class)
@DocumentedFeature
public final class PreprocessIntervals
extends GATKTool {
    public static final String BIN_LENGTH_LONG_NAME = "bin-length";
    public static final String PADDING_LONG_NAME = "padding";
    @Argument(doc="Length (in bp) of the bins.  If zero, no binning will be performed.", fullName="bin-length", optional=true, minValue=0.0)
    private int binLength = 1000;
    @Argument(doc="Length (in bp) of the padding regions on each side of the intervals.", fullName="padding", optional=true, minValue=0.0)
    private int padding = 250;
    @Argument(doc="Output Picard interval-list file containing the preprocessed intervals.", fullName="output", shortName="O")
    private File outputPreprocessedIntervalsFile;

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public void onTraversalStart() {
        this.validateArguments();
    }

    @Override
    public void traverse() {
    }

    @Override
    public Object onTraversalSuccess() {
        SAMSequenceDictionary sequenceDictionary = this.getBestAvailableSequenceDictionary();
        List<SimpleInterval> inputIntervals = this.hasUserSuppliedIntervals() ? this.intervalArgumentCollection.getIntervals(sequenceDictionary) : IntervalUtils.getAllIntervalsForReference(sequenceDictionary);
        this.logger.info("Padding intervals...");
        IntervalList paddedIntervalList = PreprocessIntervals.padIntervals(inputIntervals, this.padding, sequenceDictionary);
        this.logger.info("Generating bins...");
        IntervalList unfilteredBins = PreprocessIntervals.generateBins(paddedIntervalList, this.binLength, sequenceDictionary);
        this.logger.info("Filtering bins containing only Ns...");
        ReferenceDataSource reference = ReferenceDataSource.of(this.referenceArguments.getReferencePath());
        IntervalList bins = PreprocessIntervals.filterBinsContainingOnlyNs(unfilteredBins, reference);
        this.logger.info(String.format("Writing bins to %s...", this.outputPreprocessedIntervalsFile.getAbsolutePath()));
        bins.write(this.outputPreprocessedIntervalsFile);
        this.logger.info(String.format("%s complete.", this.getClass().getSimpleName()));
        return null;
    }

    private void validateArguments() {
        if (this.hasUserSuppliedIntervals()) {
            CopyNumberArgumentValidationUtils.validateIntervalArgumentCollection(this.intervalArgumentCollection);
        }
        CopyNumberArgumentValidationUtils.validateOutputFiles(this.outputPreprocessedIntervalsFile);
    }

    private static IntervalList padIntervals(List<SimpleInterval> inputIntervals, int padding, SAMSequenceDictionary sequenceDictionary) {
        List<SimpleInterval> paddedIntervals = inputIntervals.stream().map(i -> new SimpleInterval(i.getContig(), Math.max(1, i.getStart() - padding), Math.min(i.getEnd() + padding, sequenceDictionary.getSequence(i.getContig()).getSequenceLength()))).collect(Collectors.toList());
        for (int i2 = 0; i2 < paddedIntervals.size() - 1; ++i2) {
            SimpleInterval nextInterval;
            SimpleInterval thisInterval = (SimpleInterval)paddedIntervals.get(i2);
            if (!thisInterval.overlaps(nextInterval = (SimpleInterval)paddedIntervals.get(i2 + 1))) continue;
            int originalThisEnd = inputIntervals.get(i2).getEnd();
            int originalNextStart = inputIntervals.get(i2 + 1).getStart();
            int newThisEnd = (originalThisEnd + originalNextStart) / 2;
            int newNextStart = newThisEnd + 1;
            paddedIntervals.set(i2, new SimpleInterval(thisInterval.getContig(), thisInterval.getStart(), newThisEnd));
            paddedIntervals.set(i2 + 1, new SimpleInterval(nextInterval.getContig(), newNextStart, nextInterval.getEnd()));
        }
        IntervalList paddedIntervalList = new IntervalList(sequenceDictionary);
        paddedIntervals.forEach(i -> paddedIntervalList.add(new Interval(i.getContig(), i.getStart(), i.getEnd())));
        return paddedIntervalList;
    }

    private static IntervalList generateBins(IntervalList preparedIntervalList, int binLength, SAMSequenceDictionary sequenceDictionary) {
        if (binLength == 0) {
            return IntervalList.copyOf((IntervalList)preparedIntervalList);
        }
        IntervalList bins = new IntervalList(sequenceDictionary);
        for (Interval interval : preparedIntervalList) {
            for (int binStart = interval.getStart(); binStart <= interval.getEnd(); binStart += binLength) {
                int binEnd = FastMath.min((int)(binStart + binLength - 1), (int)interval.getEnd());
                bins.add(new Interval(interval.getContig(), binStart, binEnd));
            }
        }
        return bins;
    }

    private static IntervalList filterBinsContainingOnlyNs(IntervalList unfilteredBins, ReferenceDataSource reference) {
        IntervalList bins = new IntervalList(reference.getSequenceDictionary());
        for (Interval unfilteredBin : unfilteredBins) {
            if (Utils.stream(reference.query(new SimpleInterval((Locatable)unfilteredBin))).allMatch(b -> Nucleotide.decode(b) == Nucleotide.N)) continue;
            bins.add(unfilteredBin);
        }
        return bins;
    }
}

