/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.arguments;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.hellbender.tools.copynumber.GermlineCNVCaller;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public final class GermlineCallingArgumentCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String P_ALT_LONG_NAME = "p-alt";
    public static final String P_ACTIVE_LONG_NAME = "p-active";
    public static final String CNV_COHERENCE_LENGTH_LONG_NAME = "cnv-coherence-length";
    public static final String CLASS_COHERENCE_LENGTH_LONG_NAME = "class-coherence-length";
    public static final String MAX_COPY_NUMBER_LONG_NAME = "max-copy-number";
    @Argument(doc="Total prior probability of alternative copy-number states (the reference copy-number is set to the contig integer ploidy)", fullName="p-alt", minValue=0.0, maxValue=1.0, optional=true)
    private double pAlt = 1.0E-6;
    @Argument(doc="Prior probability of treating an interval as CNV-active (in a CNV-active domains, all copy-number states are equally likely to be called).", fullName="p-active", minValue=0.0, maxValue=1.0, optional=true)
    private double pActive = 0.01;
    @Argument(doc="Coherence length of CNV events (in the units of bp).", fullName="cnv-coherence-length", minValue=0.0, optional=true)
    private double cnvCoherenceLength = 10000.0;
    @Argument(doc="Coherence length of CNV-active and CNV-silent domains (in the units of bp).", fullName="class-coherence-length", minValue=0.0, optional=true)
    private double classCoherenceLength = 10000.0;
    @Argument(doc="Highest allowed copy-number state.", fullName="max-copy-number", minValue=0.0, optional=true)
    private int maxCopyNumber = 5;

    public List<String> generatePythonArguments(GermlineCNVCaller.RunMode runMode) {
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(String.format("--p_alt=%e", this.pAlt), String.format("--cnv_coherence_length=%e", this.cnvCoherenceLength), String.format("--max_copy_number=%d", this.maxCopyNumber)));
        if (runMode == GermlineCNVCaller.RunMode.COHORT) {
            arguments.addAll(Arrays.asList(String.format("--p_active=%f", this.pActive), String.format("--class_coherence_length=%f", this.classCoherenceLength)));
        }
        return arguments;
    }

    public void validate() {
        ParamUtils.isPositive(this.cnvCoherenceLength, String.format("Coherence length of CNV events (%s) must be positive.", CNV_COHERENCE_LENGTH_LONG_NAME));
        ParamUtils.isPositive(this.classCoherenceLength, String.format("Coherence length of CNV class domains (%s) must be positive.", CLASS_COHERENCE_LENGTH_LONG_NAME));
        ParamUtils.isPositive(this.maxCopyNumber, String.format("Highest allowed copy-number (%s) must be positive.", MAX_COPY_NUMBER_LONG_NAME));
    }
}

