/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.arguments;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.hellbender.tools.copynumber.DetermineGermlineContigPloidy;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public final class GermlineContigPloidyModelArgumentCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MEAN_BIAS_STANDARD_DEVIATION_LONG_NAME = "mean-bias-standard-deviation";
    public static final String MAPPING_ERROR_RATE_LONG_NAME = "mapping-error-rate";
    public static final String GLOBAL_PSI_SCALE_LONG_NAME = "global-psi-scale";
    public static final String SAMPLE_PSI_SCALE_LONG_NAME = "sample-psi-scale";
    @Argument(doc="Prior standard deviation of the contig-level mean coverage bias.  If a single sample is provided, this input will be ignored.", fullName="mean-bias-standard-deviation", minValue=0.0, optional=true)
    private double meanBiasStandardDeviation = 0.01;
    @Argument(doc="Typical mapping error rate.", fullName="mapping-error-rate", minValue=0.0, maxValue=1.0, optional=true)
    private double mappingErrorRate = 0.01;
    @Argument(doc="Prior scale of contig coverage unexplained variance.  If a single sample is provided, this input will be ignored.", fullName="global-psi-scale", minValue=0.0, optional=true)
    private double globalPsiScale = 0.001;
    @Argument(doc="Prior scale of the sample-specific correction to the coverage unexplained variance.", fullName="sample-psi-scale", minValue=0.0, optional=true)
    private double samplePsiScale = 1.0E-4;

    public List<String> generatePythonArguments(DetermineGermlineContigPloidy.RunMode runMode) {
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(String.format("--mapping_error_rate=%e", this.mappingErrorRate), String.format("--psi_s_scale=%e", this.samplePsiScale)));
        if (runMode == DetermineGermlineContigPloidy.RunMode.COHORT) {
            arguments.addAll(Arrays.asList(String.format("--mean_bias_sd=%e", this.meanBiasStandardDeviation), String.format("--psi_j_scale=%e", this.globalPsiScale)));
        }
        return arguments;
    }

    public void validate() {
        ParamUtils.isPositive(this.meanBiasStandardDeviation, String.format("Prior standard deviation of the contig-level mean coverage bias (%s) must be positive.", MEAN_BIAS_STANDARD_DEVIATION_LONG_NAME));
        ParamUtils.isPositive(this.mappingErrorRate, String.format("Typical mapping error rate (%s) must be positive.", MAPPING_ERROR_RATE_LONG_NAME));
        ParamUtils.isPositive(this.globalPsiScale, String.format("Prior scale of contig coverage unexplained variance (%s) must be positive.", GLOBAL_PSI_SCALE_LONG_NAME));
        ParamUtils.isPositive(this.samplePsiScale, String.format("Prior scale of the sample-specific correction to the coverage unexplained variance (%s) must be positive.", SAMPLE_PSI_SCALE_LONG_NAME));
    }
}

