/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.datacollection;

import htsjdk.samtools.util.Locatable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AllelicCountCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.AllelicCount;
import org.broadinstitute.hellbender.utils.Nucleotide;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;

public final class AllelicCountCollector {
    private static final Logger logger = LogManager.getLogger(AllelicCountCollector.class);
    public static final List<Nucleotide> BASES = Collections.unmodifiableList(Arrays.asList(Nucleotide.A, Nucleotide.C, Nucleotide.G, Nucleotide.T));
    private final SampleLocatableMetadata metadata;
    private final List<AllelicCount> allelicCounts = new ArrayList<AllelicCount>();

    public AllelicCountCollector(SampleLocatableMetadata metadata) {
        this.metadata = Utils.nonNull(metadata);
    }

    public void collectAtLocus(Nucleotide refBase, ReadPileup pileup, Locatable locus, int minBaseQuality) {
        Utils.nonNull(refBase);
        Utils.nonNull(pileup);
        Utils.nonNull(locus);
        ParamUtils.isPositiveOrZero(minBaseQuality, "Minimum base quality must be zero or higher.");
        if (!BASES.contains((Object)refBase)) {
            logger.warn(String.format("The reference position at %s has an unknown base call (value: %s). Skipping...", locus, refBase.toString()));
            return;
        }
        Nucleotide.Counter nucleotideCounter = new Nucleotide.Counter();
        Utils.stream(pileup.iterator()).filter(r -> !r.isDeletion()).filter(r -> r.getQual() >= minBaseQuality).forEach(r -> nucleotideCounter.add(r.getBase()));
        int totalBaseCount = BASES.stream().mapToInt(b -> (int)nucleotideCounter.get((Nucleotide)((Object)b))).sum();
        int refReadCount = (int)nucleotideCounter.get(refBase);
        int altReadCount = totalBaseCount - refReadCount;
        Nucleotide altBase = altReadCount == 0 ? Nucleotide.N : AllelicCountCollector.inferAltFromPileupBaseCounts(nucleotideCounter, refBase);
        this.allelicCounts.add(new AllelicCount(new SimpleInterval(locus.getContig(), locus.getStart(), locus.getEnd()), refReadCount, altReadCount, refBase, altBase));
    }

    public AllelicCountCollection getAllelicCounts() {
        return new AllelicCountCollection(this.metadata, this.allelicCounts);
    }

    private static Nucleotide inferAltFromPileupBaseCounts(Nucleotide.Counter baseCounts, Nucleotide refNucleotide) {
        return BASES.stream().filter(b -> b != refNucleotide).sorted((b1, b2) -> Long.compare(baseCounts.get((Nucleotide)((Object)b2)), baseCounts.get((Nucleotide)((Object)b1)))).findFirst().get();
    }

    public void collectFromCollector(AllelicCountCollector allelicCountCollector) {
        if (allelicCountCollector != null) {
            this.allelicCounts.addAll(allelicCountCollector.getAllelicCounts().getRecords());
        }
    }

    public static AllelicCountCollector combine(AllelicCountCollector allelicCountCollector1, AllelicCountCollector allelicCountCollector2, SampleLocatableMetadata sampleMetadata) {
        AllelicCountCollector result = new AllelicCountCollector(sampleMetadata);
        result.collectFromCollector(allelicCountCollector1);
        result.collectFromCollector(allelicCountCollector2);
        return result;
    }
}

