/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.denoising;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DefaultRealMatrixChangingVisitor;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealMatrixChangingVisitor;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public final class GCBiasCorrector {
    private static final Logger logger = LogManager.getLogger(GCBiasCorrector.class);
    private static final int NUMBER_OF_GC_BINS = 101;
    private static final double correlationLength = 0.02;
    private static final double correlationDecayRatePerBin = 0.49504950495049505;
    private final double[] gcCorrectionFactors;
    private static final double DUMMY_VALUE_NEVER_USED = 1.0;

    private GCBiasCorrector(RealVector readCounts, double[] intervalGCContent) {
        Utils.nonNull(readCounts);
        Utils.nonNull(intervalGCContent);
        Utils.validateArg(intervalGCContent.length > 0, "Number of intervals must be positive.");
        Utils.validateArg(intervalGCContent.length == readCounts.getDimension(), "Number of intervals in read-counts matrix and GC-content array do not match.");
        ArrayList<List<Double>> readCountsByGC = new ArrayList<List<Double>>(101);
        IntStream.range(0, 101).forEach(n -> readCountsByGC.add(new ArrayList()));
        IntStream.range(0, intervalGCContent.length).forEach(n -> ((List)readCountsByGC.get(GCBiasCorrector.gcContentToBinIndex(intervalGCContent[n]))).add(readCounts.getEntry(n)));
        this.gcCorrectionFactors = this.calculateCorrectionFactors(readCountsByGC);
    }

    public static void correctGCBias(RealMatrix readCounts, final double[] intervalGCContent) {
        Utils.nonNull(readCounts);
        Utils.nonNull(intervalGCContent);
        ParamUtils.isPositive(intervalGCContent.length, "Number of intervals must be positive.");
        Utils.validateArg(readCounts.getColumnDimension() == intervalGCContent.length, "Number of intervals in read-counts matrix and GC-content array do not match.");
        double[] totalCoveragePerSample = IntStream.range(0, readCounts.getRowDimension()).mapToDouble(r -> readCounts.getRowVector(r).getL1Norm()).toArray();
        final List gcBiasCorrectors = IntStream.range(0, readCounts.getRowDimension()).mapToObj(n -> new GCBiasCorrector(readCounts.getRowVector(n), intervalGCContent)).collect(Collectors.toList());
        readCounts.walkInOptimizedOrder((RealMatrixChangingVisitor)new DefaultRealMatrixChangingVisitor(){

            public double visit(int row, int interval, double readCount) {
                return ((GCBiasCorrector)gcBiasCorrectors.get(row)).correctedCoverage(readCount, intervalGCContent[interval]);
            }
        });
        final double[] sampleNormalizationFactors = IntStream.range(0, readCounts.getRowDimension()).mapToDouble(r -> totalCoveragePerSample[r] / readCounts.getRowVector(r).getL1Norm()).toArray();
        readCounts.walkInOptimizedOrder((RealMatrixChangingVisitor)new DefaultRealMatrixChangingVisitor(){

            public double visit(int row, int interval, double coverage) {
                return coverage * sampleNormalizationFactors[row];
            }
        });
    }

    private double[] calculateCorrectionFactors(List<List<Double>> readCountsByGC) {
        ArrayRealVector medians = new ArrayRealVector(readCountsByGC.stream().mapToDouble(GCBiasCorrector::medianOrDefault).toArray());
        return IntStream.range(0, 101).mapToDouble(arg_0 -> GCBiasCorrector.lambda$calculateCorrectionFactors$6(readCountsByGC, (RealVector)medians, arg_0)).map(x -> 1.0 / x).toArray();
    }

    private double correctedCoverage(double readCount, double gcContent) {
        return this.gcCorrectionFactors[GCBiasCorrector.gcContentToBinIndex(gcContent)] * readCount;
    }

    private static double medianOrDefault(List<Double> list) {
        return list.size() > 0 ? new Median().evaluate(list.stream().mapToDouble(d -> d).toArray()) : 1.0;
    }

    private static int gcContentToBinIndex(double gcContent) {
        return (int)Math.round(gcContent * 100.0);
    }

    private static /* synthetic */ double lambda$calculateCorrectionFactors$6(List readCountsByGC, RealVector medians, int bin) {
        ArrayRealVector weights = new ArrayRealVector(IntStream.range(0, 101).mapToDouble(n -> (double)((List)readCountsByGC.get(n)).size() * Math.exp((double)(-Math.abs(bin - n)) * 0.49504950495049505)).toArray());
        return weights.dotProduct(medians) / weights.getL1Norm();
    }
}

