/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.text.XReadLines;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;
import org.broadinstitute.hellbender.utils.tsv.TableUtils;

public final class CopyNumberFormatsUtils {
    public static final String COMMENT_PREFIX = "@";
    public static final String DOUBLE_FORMAT = "%.6f";

    private CopyNumberFormatsUtils() {
    }

    public static String formatDouble(double value) {
        return String.format(DOUBLE_FORMAT, value);
    }

    public static TableColumnCollection readColumnsFromHeader(File inputFile) {
        IOUtils.canReadFile(inputFile);
        List<String> columns = null;
        try (XReadLines reader = new XReadLines(inputFile);){
            while (reader.hasNext()) {
                String nextLine = reader.next();
                if (nextLine.startsWith(COMMENT_PREFIX)) continue;
                columns = Arrays.asList(nextLine.split(TableUtils.COLUMN_SEPARATOR_STRING));
                break;
            }
        }
        catch (IOException e) {
            throw new UserException.CouldNotReadInputFile(inputFile.getAbsolutePath());
        }
        if (columns == null) {
            throw new UserException.BadInput(String.format("The input file %s does not have a header (starting with comment character %s).", inputFile.getAbsolutePath(), COMMENT_PREFIX));
        }
        if (columns.stream().distinct().count() != (long)columns.size()) {
            throw new UserException.BadInput("Column headers must all be unique.");
        }
        return new TableColumnCollection(columns);
    }
}

