/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.collections;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Lazy;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.OverlapDetector;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.broadinstitute.hellbender.tools.copynumber.arguments.CopyNumberArgumentValidationUtils;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractRecordCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.LocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.Metadata;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;

public abstract class AbstractLocatableCollection<METADATA extends LocatableMetadata, RECORD extends Locatable>
extends AbstractRecordCollection<METADATA, RECORD> {
    private final Lazy<OverlapDetector<RECORD>> overlapDetector;

    AbstractLocatableCollection(METADATA metadata, List<RECORD> records, TableColumnCollection mandatoryColumns, Function<DataLine, RECORD> recordFromDataLineDecoder, BiConsumer<RECORD, DataLine> recordToDataLineEncoder) {
        super(metadata, AbstractLocatableCollection.sortRecords(records, metadata.getSequenceDictionary()), mandatoryColumns, recordFromDataLineDecoder, recordToDataLineEncoder);
        CopyNumberArgumentValidationUtils.validateIntervals(this.getRecords(), metadata.getSequenceDictionary());
        this.overlapDetector = new Lazy(() -> OverlapDetector.create(this.getRecords()));
    }

    AbstractLocatableCollection(File inputFile, TableColumnCollection mandatoryColumns, Function<DataLine, RECORD> recordFromDataLineDecoder, BiConsumer<RECORD, DataLine> recordToDataLineEncoder) {
        super(inputFile, mandatoryColumns, recordFromDataLineDecoder, recordToDataLineEncoder);
        CopyNumberArgumentValidationUtils.validateIntervals(this.getRecords(), ((LocatableMetadata)this.getMetadata()).getSequenceDictionary());
        this.overlapDetector = new Lazy(() -> OverlapDetector.create(this.getRecords()));
    }

    private static <T extends Locatable> List<T> sortRecords(List<T> records, SAMSequenceDictionary sequenceDictionary) {
        Utils.nonNull(records);
        Utils.nonNull(sequenceDictionary);
        return records.stream().sorted(IntervalUtils.getDictionaryOrderComparator(sequenceDictionary)).collect(Collectors.toList());
    }

    public List<SimpleInterval> getIntervals() {
        return this.getRecords().stream().map(r -> new SimpleInterval(r.getContig(), r.getStart(), r.getEnd())).collect(Collectors.toList());
    }

    public OverlapDetector<RECORD> getOverlapDetector() {
        return (OverlapDetector)this.overlapDetector.get();
    }

    public Comparator<Locatable> getComparator() {
        return IntervalUtils.getDictionaryOrderComparator(((LocatableMetadata)this.getMetadata()).getSequenceDictionary());
    }

    @Override
    protected Metadata.Type getMetadataType() {
        return Metadata.Type.LOCATABLE;
    }

    public static <METADATA extends LocatableMetadata, RECORD extends Locatable> List<Integer> getShardedCollectionSortOrder(@Nonnull List<? extends AbstractLocatableCollection<METADATA, RECORD>> collections) {
        Utils.nonNull(collections);
        collections.forEach(Utils::nonNull);
        Utils.validateArg(!collections.isEmpty(), "The list must contain at least one collection.");
        LocatableMetadata firstMetadata = (LocatableMetadata)collections.get(0).getMetadata();
        Utils.validateArg(collections.stream().map(AbstractRecordCollection::getMetadata).allMatch(metadata -> metadata.equals(firstMetadata)), "The collections must have the same metadata.");
        int numShards = collections.size();
        List<Integer> sortOrder = IntStream.range(0, numShards).mapToObj(shardIndex -> ImmutablePair.of((Object)shardIndex, ((AbstractLocatableCollection)collections.get(shardIndex)).getRecords().get(0))).sorted((p1, p2) -> IntervalUtils.compareLocatables((Locatable)p1.getValue(), (Locatable)p2.getValue(), firstMetadata.getSequenceDictionary())).map(ImmutablePair::getLeft).collect(Collectors.toList());
        List sortedAssembledRecordList = sortOrder.stream().map(idx -> ((AbstractLocatableCollection)collections.get((int)idx)).getRecords()).flatMap(Collection::stream).collect(Collectors.toList());
        CopyNumberArgumentValidationUtils.validateIntervals(sortedAssembledRecordList, firstMetadata.getSequenceDictionary());
        return sortOrder;
    }
}

