/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.collections;

import com.google.common.collect.ImmutableList;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.LineReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.copynumber.formats.CopyNumberFormatsUtils;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.Metadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.MetadataUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;
import org.broadinstitute.hellbender.utils.tsv.TableReader;
import org.broadinstitute.hellbender.utils.tsv.TableUtils;
import org.broadinstitute.hellbender.utils.tsv.TableWriter;

public abstract class AbstractRecordCollection<METADATA extends Metadata, RECORD> {
    private final METADATA metadata;
    private final ImmutableList<RECORD> records;
    private final TableColumnCollection mandatoryColumns;
    private final Function<DataLine, RECORD> recordFromDataLineDecoder;
    private final BiConsumer<RECORD, DataLine> recordToDataLineEncoder;

    AbstractRecordCollection(METADATA metadata, List<RECORD> records, TableColumnCollection mandatoryColumns, Function<DataLine, RECORD> recordFromDataLineDecoder, BiConsumer<RECORD, DataLine> recordToDataLineEncoder) {
        this.metadata = (Metadata)Utils.nonNull(metadata);
        this.records = ImmutableList.copyOf((Collection)Utils.nonNull(records));
        this.mandatoryColumns = Utils.nonNull(mandatoryColumns);
        this.recordFromDataLineDecoder = Utils.nonNull(recordFromDataLineDecoder);
        this.recordToDataLineEncoder = Utils.nonNull(recordToDataLineEncoder);
        Utils.nonEmpty(mandatoryColumns.names());
    }

    AbstractRecordCollection(File inputFile, TableColumnCollection mandatoryColumns, Function<DataLine, RECORD> recordFromDataLineDecoder, BiConsumer<RECORD, DataLine> recordToDataLineEncoder) {
        IOUtils.canReadFile(inputFile);
        this.mandatoryColumns = Utils.nonNull(mandatoryColumns);
        this.recordFromDataLineDecoder = Utils.nonNull(recordFromDataLineDecoder);
        this.recordToDataLineEncoder = Utils.nonNull(recordToDataLineEncoder);
        Utils.nonEmpty(mandatoryColumns.names());
        try (RecordCollectionReader reader = new RecordCollectionReader(IOUtils.fileToPath(inputFile));){
            this.metadata = MetadataUtils.fromHeader(reader.getHeader(), this.getMetadataType());
            TableUtils.checkMandatoryColumns(reader.columns(), mandatoryColumns, UserException.BadInput::new);
            this.records = ImmutableList.copyOf(reader.stream().iterator());
        }
        catch (IOException | UncheckedIOException e) {
            throw new UserException.CouldNotReadInputFile(inputFile.getAbsolutePath(), e);
        }
    }

    public final int size() {
        return this.records.size();
    }

    abstract Metadata.Type getMetadataType();

    public METADATA getMetadata() {
        return this.metadata;
    }

    public final List<RECORD> getRecords() {
        return this.records;
    }

    public void write(File outputFile) {
        Throwable throwable;
        Closeable writer;
        Utils.nonNull(outputFile);
        try {
            writer = new FileWriter(outputFile);
            throwable = null;
            try {
                ((Writer)writer).write(this.metadata.toHeader().getSAMString());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            ((OutputStreamWriter)writer).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((OutputStreamWriter)writer).close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile(outputFile, (Exception)e);
        }
        try {
            writer = new RecordCollectionWriter(new FileWriter(outputFile, true));
            throwable = null;
            try {
                ((TableWriter)writer).writeAllRecords(this.records);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            ((TableWriter)writer).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((TableWriter)writer).close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile(outputFile, (Exception)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRecordCollection that = (AbstractRecordCollection)o;
        return this.metadata.equals(that.metadata) && this.records.equals(that.records) && this.mandatoryColumns.equals(that.mandatoryColumns) && this.recordFromDataLineDecoder.equals(that.recordFromDataLineDecoder) && this.recordToDataLineEncoder.equals(that.recordToDataLineEncoder);
    }

    public int hashCode() {
        int result = this.metadata.hashCode();
        result = 31 * result + this.records.hashCode();
        result = 31 * result + this.mandatoryColumns.hashCode();
        result = 31 * result + this.recordFromDataLineDecoder.hashCode();
        result = 31 * result + this.recordToDataLineEncoder.hashCode();
        return result;
    }

    public String toString() {
        return "AbstractRecordCollection{metadata=" + this.metadata + ", records=" + this.records + '}';
    }

    static String formatDouble(double value) {
        return CopyNumberFormatsUtils.formatDouble(value);
    }

    final class RecordCollectionWriter
    extends TableWriter<RECORD> {
        RecordCollectionWriter(Writer writer) throws IOException {
            super(writer, AbstractRecordCollection.this.mandatoryColumns);
        }

        @Override
        protected void composeLine(RECORD record, DataLine dataLine) {
            Utils.nonNull(record);
            Utils.nonNull(dataLine);
            AbstractRecordCollection.this.recordToDataLineEncoder.accept(record, dataLine);
        }
    }

    final class RecordCollectionReader
    extends TableReader<RECORD> {
        private static final String COMMENT_PREFIX = "@";
        private final Path path;

        RecordCollectionReader(Path path) throws IOException {
            super(path);
            this.path = path;
        }

        @Override
        protected RECORD createRecord(DataLine dataLine) {
            Utils.nonNull(dataLine);
            return AbstractRecordCollection.this.recordFromDataLineDecoder.apply(dataLine);
        }

        private SAMFileHeader getHeader() {
            try (BufferedLineReader lineReader = new BufferedLineReader(BucketUtils.openFile(this.path.toString()));){
                SAMFileHeader sAMFileHeader = new SAMTextHeaderCodec().decode((LineReader)lineReader, this.getSource());
                return sAMFileHeader;
            }
        }

        @Override
        protected boolean isCommentLine(String[] line) {
            return line.length > 0 && line[0].startsWith(COMMENT_PREFIX);
        }
    }
}

