/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.collections;

import java.io.File;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractSampleLocatableCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.AlleleFractionSegment;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;

public final class AlleleFractionSegmentCollection
extends AbstractSampleLocatableCollection<AlleleFractionSegment> {
    private static final Function<DataLine, AlleleFractionSegment> ALLELE_FRACTION_SEGMENT_DATA_LINE_TO_RECORD_FUNCTION = dataLine -> {
        String contig = dataLine.get(AlleleFractionSegmentTableColumn.CONTIG);
        int start = dataLine.getInt(AlleleFractionSegmentTableColumn.START);
        int end = dataLine.getInt(AlleleFractionSegmentTableColumn.END);
        int numPoints = dataLine.getInt(AlleleFractionSegmentTableColumn.NUM_POINTS_ALLELE_FRACTION);
        SimpleInterval interval = new SimpleInterval(contig, start, end);
        return new AlleleFractionSegment(interval, numPoints);
    };
    private static final BiConsumer<AlleleFractionSegment, DataLine> ALLELE_FRACTION_SEGMENT_RECORD_AND_DATA_LINE_BI_CONSUMER = (alleleFractionSegment, dataLine) -> dataLine.append(alleleFractionSegment.getContig()).append(alleleFractionSegment.getStart()).append(alleleFractionSegment.getEnd()).append(alleleFractionSegment.getNumPoints());

    public AlleleFractionSegmentCollection(File inputFile) {
        super(inputFile, AlleleFractionSegmentTableColumn.COLUMNS, ALLELE_FRACTION_SEGMENT_DATA_LINE_TO_RECORD_FUNCTION, ALLELE_FRACTION_SEGMENT_RECORD_AND_DATA_LINE_BI_CONSUMER);
    }

    public AlleleFractionSegmentCollection(SampleLocatableMetadata metadata, List<AlleleFractionSegment> AlleleFractionSegments) {
        super(metadata, AlleleFractionSegments, AlleleFractionSegmentTableColumn.COLUMNS, ALLELE_FRACTION_SEGMENT_DATA_LINE_TO_RECORD_FUNCTION, ALLELE_FRACTION_SEGMENT_RECORD_AND_DATA_LINE_BI_CONSUMER);
    }

    static enum AlleleFractionSegmentTableColumn {
        CONTIG,
        START,
        END,
        NUM_POINTS_ALLELE_FRACTION;

        static final TableColumnCollection COLUMNS;

        static {
            COLUMNS = new TableColumnCollection((Object[])AlleleFractionSegmentTableColumn.values());
        }
    }
}

