/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.collections;

import java.io.File;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractSampleLocatableCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.AllelicCount;
import org.broadinstitute.hellbender.utils.Nucleotide;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;

public final class AllelicCountCollection
extends AbstractSampleLocatableCollection<AllelicCount> {
    private static final Function<DataLine, AllelicCount> ALLELIC_COUNT_RECORD_FROM_DATA_LINE_DECODER = dataLine -> {
        String contig = dataLine.get(AllelicCountTableColumn.CONTIG);
        int position = dataLine.getInt(AllelicCountTableColumn.POSITION);
        int refReadCount = dataLine.getInt(AllelicCountTableColumn.REF_COUNT);
        int altReadCount = dataLine.getInt(AllelicCountTableColumn.ALT_COUNT);
        Nucleotide refNucleotide = Nucleotide.decode(dataLine.get(AllelicCountTableColumn.REF_NUCLEOTIDE.name()).charAt(0));
        Nucleotide altNucleotide = Nucleotide.decode(dataLine.get(AllelicCountTableColumn.ALT_NUCLEOTIDE.name()).charAt(0));
        SimpleInterval interval = new SimpleInterval(contig, position, position);
        return new AllelicCount(interval, refReadCount, altReadCount, refNucleotide, altNucleotide);
    };
    private static final BiConsumer<AllelicCount, DataLine> ALLELIC_COUNT_RECORD_TO_DATA_LINE_ENCODER = (allelicCount, dataLine) -> dataLine.append(allelicCount.getInterval().getContig()).append(allelicCount.getInterval().getEnd()).append(allelicCount.getRefReadCount()).append(allelicCount.getAltReadCount()).append(allelicCount.getRefNucleotide().name()).append(allelicCount.getAltNucleotide().name());

    public AllelicCountCollection(File inputFile) {
        super(inputFile, AllelicCountTableColumn.COLUMNS, ALLELIC_COUNT_RECORD_FROM_DATA_LINE_DECODER, ALLELIC_COUNT_RECORD_TO_DATA_LINE_ENCODER);
    }

    public AllelicCountCollection(SampleLocatableMetadata metadata, List<AllelicCount> AllelicCounts) {
        super(metadata, AllelicCounts, AllelicCountTableColumn.COLUMNS, ALLELIC_COUNT_RECORD_FROM_DATA_LINE_DECODER, ALLELIC_COUNT_RECORD_TO_DATA_LINE_ENCODER);
    }

    static enum AllelicCountTableColumn {
        CONTIG,
        POSITION,
        REF_COUNT,
        ALT_COUNT,
        REF_NUCLEOTIDE,
        ALT_NUCLEOTIDE;

        static final TableColumnCollection COLUMNS;

        static {
            COLUMNS = new TableColumnCollection((Object[])AllelicCountTableColumn.values());
        }
    }
}

