/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.collections;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.copynumber.formats.CopyNumberFormatsUtils;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractLocatableCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractRecordCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.LocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.AnnotatedInterval;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.annotation.AnnotationKey;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.annotation.AnnotationMap;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.annotation.CopyNumberAnnotations;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;

public final class AnnotatedIntervalCollection
extends AbstractLocatableCollection<LocatableMetadata, AnnotatedInterval> {
    private static final BiConsumer<AnnotatedInterval, DataLine> ANNOTATED_INTERVAL_RECORD_TO_DATA_LINE_ENCODER = (annotatedInterval, dataLine) -> {
        dataLine.append(annotatedInterval.getInterval().getContig()).append(annotatedInterval.getInterval().getStart()).append(annotatedInterval.getInterval().getEnd());
        AnnotationMap annotations = annotatedInterval.getAnnotationMap();
        block6: for (AnnotationKey<?> key : annotations.getKeys()) {
            AnnotationValueType type = AnnotationValueType.valueOf(key.getType().getSimpleName());
            switch (type) {
                case Integer: {
                    dataLine.append((int)((Integer)annotations.getValue(key)));
                    continue block6;
                }
                case Long: {
                    dataLine.append((long)((Long)annotations.getValue(key)));
                    continue block6;
                }
                case Double: {
                    dataLine.append(AnnotatedIntervalCollection.formatDouble((Double)annotations.getValue(key)));
                    continue block6;
                }
                case String: {
                    dataLine.append((String)annotations.getValue(key));
                    continue block6;
                }
            }
            throw new UserException.BadInput(String.format("Unsupported annotation type: %s", new Object[]{type}));
        }
    };

    public AnnotatedIntervalCollection(File inputFile) {
        this(inputFile, AnnotatedIntervalCollection.getAnnotationKeys(CopyNumberFormatsUtils.readColumnsFromHeader(inputFile)));
    }

    private AnnotatedIntervalCollection(File inputFile, List<AnnotationKey<?>> annotationKeys) {
        super(inputFile, AnnotatedIntervalCollection.getColumns(annotationKeys), AnnotatedIntervalCollection.getAnnotatedIntervalRecordFromDataLineDecoder(annotationKeys), ANNOTATED_INTERVAL_RECORD_TO_DATA_LINE_ENCODER);
    }

    public AnnotatedIntervalCollection(LocatableMetadata metadata, List<AnnotatedInterval> annotatedIntervals) {
        super(metadata, annotatedIntervals, AnnotatedIntervalCollection.getColumns(AnnotatedIntervalCollection.getAnnotationKeys(annotatedIntervals)), AnnotatedIntervalCollection.getAnnotatedIntervalRecordFromDataLineDecoder(AnnotatedIntervalCollection.getAnnotationKeys(annotatedIntervals)), ANNOTATED_INTERVAL_RECORD_TO_DATA_LINE_ENCODER);
    }

    private static TableColumnCollection getColumns(List<AnnotationKey<?>> annotationKeys) {
        return new TableColumnCollection(ListUtils.union(AnnotatedIntervalTableColumn.STANDARD_COLUMNS.names(), annotationKeys.stream().map(AnnotationKey::getName).collect(Collectors.toList())));
    }

    private static List<AnnotationKey<?>> getAnnotationKeys(TableColumnCollection columns) {
        Utils.nonNull(columns);
        Utils.validateArg(columns.columnCount() != 0, "TableColumnCollection cannot be empty.");
        Utils.validateArg(columns.containsAll(AnnotatedIntervalTableColumn.STANDARD_COLUMNS.names()), String.format("TableColumnCollection must contain standard columns: %s.", AnnotatedIntervalTableColumn.STANDARD_COLUMNS.names()));
        return CopyNumberAnnotations.ANNOTATIONS.stream().filter(a -> columns.contains(a.getName())).collect(Collectors.toList());
    }

    private static List<AnnotationKey<?>> getAnnotationKeys(List<AnnotatedInterval> annotatedIntervals) {
        return annotatedIntervals.isEmpty() ? new ArrayList() : annotatedIntervals.get(0).getAnnotationMap().getKeys();
    }

    private static Function<DataLine, AnnotatedInterval> getAnnotatedIntervalRecordFromDataLineDecoder(List<AnnotationKey<?>> annotationKeys) {
        return dataLine -> {
            String contig = dataLine.get(AnnotatedIntervalTableColumn.CONTIG);
            int start = dataLine.getInt(AnnotatedIntervalTableColumn.START);
            int end = dataLine.getInt(AnnotatedIntervalTableColumn.END);
            SimpleInterval interval = new SimpleInterval(contig, start, end);
            ArrayList annotations = new ArrayList(annotationKeys.size());
            block6: for (AnnotationKey key : annotationKeys) {
                AnnotationValueType type = AnnotationValueType.valueOf(key.getType().getSimpleName());
                switch (type) {
                    case Integer: {
                        annotations.add(Pair.of((Object)key, (Object)dataLine.getInt(key.getName())));
                        continue block6;
                    }
                    case Long: {
                        annotations.add(Pair.of((Object)key, (Object)dataLine.getLong(key.getName())));
                        continue block6;
                    }
                    case Double: {
                        annotations.add(Pair.of((Object)key, (Object)dataLine.getDouble(key.getName())));
                        continue block6;
                    }
                    case String: {
                        annotations.add(Pair.of((Object)key, (Object)dataLine.get(key.getName())));
                        continue block6;
                    }
                }
                throw new UserException.BadInput(String.format("Unsupported annotation type: %s", new Object[]{type}));
            }
            AnnotationMap annotationMap = new AnnotationMap(annotations);
            return new AnnotatedInterval(interval, annotationMap);
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRecordCollection that = (AbstractRecordCollection)o;
        return ((LocatableMetadata)this.getMetadata()).equals(that.getMetadata()) && this.getRecords().equals(that.getRecords());
    }

    @Override
    public int hashCode() {
        int result = ((LocatableMetadata)this.getMetadata()).hashCode();
        result = 31 * result + this.getRecords().hashCode();
        return result;
    }

    static enum AnnotationValueType {
        Integer,
        Long,
        Double,
        String;

    }

    static enum AnnotatedIntervalTableColumn {
        CONTIG,
        START,
        END;

        static final TableColumnCollection STANDARD_COLUMNS;

        static {
            STANDARD_COLUMNS = new TableColumnCollection((Object[])AnnotatedIntervalTableColumn.values());
        }
    }
}

