/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.collections;

import java.io.File;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractSampleRecordCollection;
import org.broadinstitute.hellbender.tools.copynumber.gcnv.IntegerCopyNumberState;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;

public final class BaselineCopyNumberCollection
extends AbstractSampleRecordCollection<IntegerCopyNumberState> {
    public BaselineCopyNumberCollection(File inputFile) {
        super(inputFile, new TableColumnCollection("BASELINE_COPY_NUMBER"), BaselineCopyNumberCollection.getBaselineCopyNumberRecordFromDataLineDecoder(inputFile), BaselineCopyNumberCollection.getBaselineCopyNumberRecordToDataLineEncoder());
    }

    private static Function<DataLine, IntegerCopyNumberState> getBaselineCopyNumberRecordFromDataLineDecoder(File inputFile) {
        return dataLine -> {
            try {
                return new IntegerCopyNumberState(dataLine.getInt("BASELINE_COPY_NUMBER"));
            }
            catch (IllegalArgumentException ex) {
                throw new UserException.BadInput(String.format("Error parsing baseline copy-number file (%s) at line %d.", inputFile.getAbsolutePath(), dataLine.getLineNumber()));
            }
        };
    }

    private static BiConsumer<IntegerCopyNumberState, DataLine> getBaselineCopyNumberRecordToDataLineEncoder() {
        return (baselineCopyNumberState, dataLine) -> dataLine.append(baselineCopyNumberState.getCopyNumber());
    }
}

