/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.collections;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.broadinstitute.barclay.utils.Utils;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractRecordCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractSampleLocatableCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.CalledCopyRatioSegmentCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.CopyRatioSegmentCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.CalledCopyRatioSegment;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.CalledLegacySegment;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;

public final class CalledLegacySegmentCollection
extends AbstractSampleLocatableCollection<CalledLegacySegment> {
    private static final Function<DataLine, CalledLegacySegment> CALLED_LEGACY_SEGMENT_DATA_LINE_TO_RECORD_FUNCTION = dataLine -> {
        String sampleName = dataLine.get(CalledLegacySegmentTableColumn.SAMPLE.columnName);
        String contig = dataLine.get(CalledLegacySegmentTableColumn.CHROMOSOME.columnName);
        int start = dataLine.getInt(CalledLegacySegmentTableColumn.START.columnName);
        int end = dataLine.getInt(CalledLegacySegmentTableColumn.END.columnName);
        int numProbes = dataLine.getInt(CalledLegacySegmentTableColumn.NUM_PROBES.columnName);
        double segmentMean = dataLine.getDouble(CalledLegacySegmentTableColumn.SEGMENT_MEAN.columnName);
        String callOutputString = dataLine.get(CalledCopyRatioSegmentCollection.CalledCopyRatioSegmentTableColumn.CALL);
        CalledCopyRatioSegment.Call call = Arrays.stream(CalledCopyRatioSegment.Call.values()).filter(c -> c.getOutputString().equals(callOutputString)).findFirst().orElseThrow(() -> new UserException("Attempting to read an invalid value for " + (Object)((Object)CalledLegacySegmentTableColumn.CALL) + ": " + callOutputString + ".  Valid values are " + StringUtils.join((Object[])CalledCopyRatioSegment.Call.values(), (String)", ")));
        SimpleInterval interval = new SimpleInterval(contig, start, end);
        return new CalledLegacySegment(sampleName, interval, numProbes, segmentMean, call);
    };
    private static final BiConsumer<CalledLegacySegment, DataLine> CALLED_LEGACY_SEGMENT_RECORD_AND_DATA_LINE_BI_CONSUMER = (calledLegacySegment, dataLine) -> dataLine.append(calledLegacySegment.getSampleName()).append(calledLegacySegment.getContig()).append(calledLegacySegment.getStart()).append(calledLegacySegment.getEnd()).append(calledLegacySegment.getNumProbes()).append(calledLegacySegment.getCall().getOutputString()).append(CalledLegacySegmentCollection.formatDouble(calledLegacySegment.getSegmentMean()));

    public CalledLegacySegmentCollection(SampleLocatableMetadata metadata, List<CalledLegacySegment> calledLegacySegments) {
        super(metadata, calledLegacySegments, CalledLegacySegmentTableColumn.COLUMNS, CALLED_LEGACY_SEGMENT_DATA_LINE_TO_RECORD_FUNCTION, CALLED_LEGACY_SEGMENT_RECORD_AND_DATA_LINE_BI_CONSUMER);
    }

    public CalledLegacySegmentCollection(File inputFile) {
        super(inputFile, CopyRatioSegmentCollection.CopyRatioSegmentTableColumn.COLUMNS, CALLED_LEGACY_SEGMENT_DATA_LINE_TO_RECORD_FUNCTION, CALLED_LEGACY_SEGMENT_RECORD_AND_DATA_LINE_BI_CONSUMER);
    }

    @Override
    public void write(File outputFile) {
        Utils.nonNull((Object)outputFile);
        try (AbstractRecordCollection.RecordCollectionWriter writer = new AbstractRecordCollection.RecordCollectionWriter(this, new FileWriter(outputFile));){
            writer.writeAllRecords(this.getRecords());
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile(outputFile, (Exception)e);
        }
    }

    static enum CalledLegacySegmentTableColumn {
        SAMPLE("Sample"),
        CHROMOSOME("Chromosome"),
        START("Start"),
        END("End"),
        NUM_PROBES("Num_Probes"),
        CALL("Call"),
        SEGMENT_MEAN("Segment_Mean");

        private final String columnName;
        static final TableColumnCollection COLUMNS;

        private CalledLegacySegmentTableColumn(String columnName) {
            this.columnName = columnName;
        }

        static {
            COLUMNS = new TableColumnCollection(Stream.of(CalledLegacySegmentTableColumn.values()).map(c -> c.columnName).toArray());
        }
    }
}

