/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.collections;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.copynumber.formats.CopyNumberFormatsUtils;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractSampleRecordCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.CopyNumberPosteriorDistribution;
import org.broadinstitute.hellbender.tools.copynumber.gcnv.IntegerCopyNumberState;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;

public final class CopyNumberPosteriorDistributionCollection
extends AbstractSampleRecordCollection<CopyNumberPosteriorDistribution> {
    public CopyNumberPosteriorDistributionCollection(File inputFile) {
        this(inputFile, new IntegerCopyNumberStateCollection(inputFile));
    }

    private CopyNumberPosteriorDistributionCollection(File inputFile, IntegerCopyNumberStateCollection integerCopyNumberStateCollection) {
        super(inputFile, Utils.nonNull(integerCopyNumberStateCollection).getTableColumnCollection(), CopyNumberPosteriorDistributionCollection.getPosteriorRecordFromDataLineDecoder(integerCopyNumberStateCollection), CopyNumberPosteriorDistributionCollection.getPosteriorRecordToDataLineEncoder(integerCopyNumberStateCollection));
    }

    private static Function<DataLine, CopyNumberPosteriorDistribution> getPosteriorRecordFromDataLineDecoder(IntegerCopyNumberStateCollection integerCopyNumberStateCollection) {
        return dataLine -> {
            try {
                return new CopyNumberPosteriorDistribution(IntStream.range(0, integerCopyNumberStateCollection.size()).mapToObj(integerCopyNumberStateCollection::get).collect(Collectors.toMap(Function.identity(), state -> dataLine.getDouble(state.getCopyNumber()))));
            }
            catch (IllegalArgumentException ex) {
                throw new UserException.BadInput(String.format("Validation error occurred on line %d of the posterior file: ", dataLine.getLineNumber()) + ex.getMessage());
            }
        };
    }

    private static BiConsumer<CopyNumberPosteriorDistribution, DataLine> getPosteriorRecordToDataLineEncoder(IntegerCopyNumberStateCollection integerCopyNumberStateCollection) {
        return (copyNumberPosteriorRecord, dataLine) -> integerCopyNumberStateCollection.getCopyNumberStates().forEach(state -> dataLine.append(copyNumberPosteriorRecord.getCopyNumberPosterior((IntegerCopyNumberState)state)));
    }

    private static class IntegerCopyNumberStateCollection {
        private final List<IntegerCopyNumberState> copyNumberStates;
        private final TableColumnCollection columnCollection;

        IntegerCopyNumberStateCollection(File inputFile) {
            this.columnCollection = CopyNumberFormatsUtils.readColumnsFromHeader(inputFile);
            this.copyNumberStates = new ArrayList<IntegerCopyNumberState>();
            this.columnCollection.names().forEach(copyNumberString -> this.copyNumberStates.add(this.parseIntegerCopyNumber((String)copyNumberString)));
        }

        List<IntegerCopyNumberState> getCopyNumberStates() {
            return this.copyNumberStates;
        }

        IntegerCopyNumberState get(int index) {
            return this.copyNumberStates.get(index);
        }

        int size() {
            return this.columnCollection.columnCount();
        }

        TableColumnCollection getTableColumnCollection() {
            return this.columnCollection;
        }

        private IntegerCopyNumberState parseIntegerCopyNumber(String copyNumberStateString) {
            if (!copyNumberStateString.startsWith("COPY_NUMBER_")) {
                throw new UserException.BadInput(String.format("The column names of the copy number posterior file must start with %s.", "COPY_NUMBER_"));
            }
            String integerCopyNumberStateString = copyNumberStateString.substring("COPY_NUMBER_".length());
            try {
                int copyNumber = Integer.parseInt(integerCopyNumberStateString);
                return new IntegerCopyNumberState(copyNumber);
            }
            catch (NumberFormatException e) {
                throw new UserException.BadInput(String.format("Could not parse copy-number column string (%s) to an integer copy-number.", copyNumberStateString));
            }
        }
    }
}

