/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.collections;

import htsjdk.samtools.util.OverlapDetector;
import java.io.File;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractSampleLocatableCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.CopyRatio;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;

public final class CopyRatioCollection
extends AbstractSampleLocatableCollection<CopyRatio> {
    private static final Function<DataLine, CopyRatio> COPY_RATIO_RECORD_FROM_DATA_LINE_DECODER = dataLine -> {
        String contig = dataLine.get(CopyRatioTableColumn.CONTIG);
        int start = dataLine.getInt(CopyRatioTableColumn.START);
        int end = dataLine.getInt(CopyRatioTableColumn.END);
        double copyRatio = dataLine.getDouble(CopyRatioTableColumn.LOG2_COPY_RATIO);
        SimpleInterval interval = new SimpleInterval(contig, start, end);
        return new CopyRatio(interval, copyRatio);
    };
    private static final BiConsumer<CopyRatio, DataLine> COPY_RATIO_RECORD_TO_DATA_LINE_ENCODER = (copyRatio, dataLine) -> dataLine.append(copyRatio.getInterval().getContig()).append(copyRatio.getInterval().getStart()).append(copyRatio.getInterval().getEnd()).append(CopyRatioCollection.formatDouble(copyRatio.getLog2CopyRatioValue()));

    public CopyRatioCollection(File inputFile) {
        super(inputFile, CopyRatioTableColumn.COLUMNS, COPY_RATIO_RECORD_FROM_DATA_LINE_DECODER, COPY_RATIO_RECORD_TO_DATA_LINE_ENCODER);
    }

    public CopyRatioCollection(SampleLocatableMetadata metadata, List<CopyRatio> copyRatios) {
        super(metadata, copyRatios, CopyRatioTableColumn.COLUMNS, COPY_RATIO_RECORD_FROM_DATA_LINE_DECODER, COPY_RATIO_RECORD_TO_DATA_LINE_ENCODER);
    }

    public List<Double> getLog2CopyRatioValues() {
        return this.getRecords().stream().map(CopyRatio::getLog2CopyRatioValue).collect(Collectors.toList());
    }

    public OverlapDetector<CopyRatio> getMidpointOverlapDetector() {
        return OverlapDetector.create(this.getRecords().stream().map(cr -> new CopyRatio(cr.getMidpoint(), cr.getLog2CopyRatioValue())).collect(Collectors.toList()));
    }

    static enum CopyRatioTableColumn {
        CONTIG,
        START,
        END,
        LOG2_COPY_RATIO;

        static final TableColumnCollection COLUMNS;

        static {
            COLUMNS = new TableColumnCollection((Object[])CopyRatioTableColumn.values());
        }
    }
}

