/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.collections;

import java.io.File;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractSampleLocatableCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.CopyRatioSegment;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;

public final class CopyRatioSegmentCollection
extends AbstractSampleLocatableCollection<CopyRatioSegment> {
    private static final Function<DataLine, CopyRatioSegment> COPY_RATIO_SEGMENT_RECORD_FROM_DATA_LINE_DECODER = dataLine -> {
        String contig = dataLine.get(CopyRatioSegmentTableColumn.CONTIG);
        int start = dataLine.getInt(CopyRatioSegmentTableColumn.START);
        int end = dataLine.getInt(CopyRatioSegmentTableColumn.END);
        int numPoints = dataLine.getInt(CopyRatioSegmentTableColumn.NUM_POINTS_COPY_RATIO);
        double meanLog2CopyRatio = dataLine.getDouble(CopyRatioSegmentTableColumn.MEAN_LOG2_COPY_RATIO);
        SimpleInterval interval = new SimpleInterval(contig, start, end);
        return new CopyRatioSegment(interval, numPoints, meanLog2CopyRatio);
    };
    private static final BiConsumer<CopyRatioSegment, DataLine> COPY_RATIO_SEGMENT_RECORD_TO_DATA_LINE_ENCODER = (copyRatioSegment, dataLine) -> dataLine.append(copyRatioSegment.getInterval().getContig()).append(copyRatioSegment.getInterval().getStart()).append(copyRatioSegment.getInterval().getEnd()).append(copyRatioSegment.getNumPoints()).append(CopyRatioSegmentCollection.formatDouble(copyRatioSegment.getMeanLog2CopyRatio()));

    public CopyRatioSegmentCollection(File inputFile) {
        super(inputFile, CopyRatioSegmentTableColumn.COLUMNS, COPY_RATIO_SEGMENT_RECORD_FROM_DATA_LINE_DECODER, COPY_RATIO_SEGMENT_RECORD_TO_DATA_LINE_ENCODER);
    }

    public CopyRatioSegmentCollection(SampleLocatableMetadata metadata, List<CopyRatioSegment> copyRatioSegments) {
        super(metadata, copyRatioSegments, CopyRatioSegmentTableColumn.COLUMNS, COPY_RATIO_SEGMENT_RECORD_FROM_DATA_LINE_DECODER, COPY_RATIO_SEGMENT_RECORD_TO_DATA_LINE_ENCODER);
    }

    static enum CopyRatioSegmentTableColumn {
        CONTIG,
        START,
        END,
        NUM_POINTS_COPY_RATIO,
        MEAN_LOG2_COPY_RATIO;

        static final TableColumnCollection COLUMNS;

        static {
            COLUMNS = new TableColumnCollection((Object[])CopyRatioSegmentTableColumn.values());
        }
    }
}

