/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.collections;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.Lazy;
import htsjdk.samtools.util.LineReader;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.broadinstitute.hdf5.HDF5File;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SimpleSampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.utils.HDF5Utils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

public final class HDF5SimpleCountCollection {
    private static final String SAMPLE_NAME_PATH = "/sample_metadata/sample_name";
    private static final String SEQUENCE_DICTIONARY_PATH = "/locatable_metadata/sequence_dictionary";
    private static final String INTERVALS_GROUP_NAME = "/intervals";
    private static final String COUNTS_PATH = "/counts/values";
    private final HDF5File file;
    private final Lazy<String> sampleName;
    private final Lazy<SAMSequenceDictionary> sequenceDictionary;
    private final Lazy<List<SimpleInterval>> intervals;
    private final Lazy<RealMatrix> counts;

    HDF5SimpleCountCollection(HDF5File file) {
        Utils.nonNull(file);
        this.file = file;
        this.sampleName = new Lazy(() -> file.readStringArray(SAMPLE_NAME_PATH)[0]);
        this.sequenceDictionary = new Lazy(() -> {
            String sequenceDictionaryString = file.readStringArray(SEQUENCE_DICTIONARY_PATH)[0];
            return new SAMTextHeaderCodec().decode((LineReader)BufferedLineReader.fromString((String)sequenceDictionaryString), file.getFile().getAbsolutePath()).getSequenceDictionary();
        });
        this.intervals = new Lazy(() -> HDF5Utils.readIntervals(file, INTERVALS_GROUP_NAME));
        this.counts = new Lazy(() -> new Array2DRowRealMatrix(file.readDoubleMatrix(COUNTS_PATH)));
    }

    SampleLocatableMetadata getMetadata() {
        return new SimpleSampleLocatableMetadata((String)this.sampleName.get(), (SAMSequenceDictionary)this.sequenceDictionary.get());
    }

    List<SimpleInterval> getIntervals() {
        return (List)this.intervals.get();
    }

    RealMatrix getCounts() {
        return (RealMatrix)this.counts.get();
    }

    static void write(File outFile, SampleLocatableMetadata metadata, List<SimpleInterval> intervals, double[] counts) {
        Utils.nonNull(outFile);
        Utils.nonNull(metadata);
        Utils.nonEmpty(intervals);
        Utils.nonNull(counts);
        Utils.validateArg(intervals.size() == counts.length, "Number of intervals and counts must match.");
        Utils.validateArg(intervals.stream().distinct().count() == (long)intervals.size(), "Intervals must all be unique.");
        Utils.validateArg(Arrays.stream(counts).noneMatch(c -> c < 0.0), "Counts must all be non-negative integers.");
        try (HDF5File file = new HDF5File(outFile, HDF5File.OpenMode.CREATE);){
            HDF5SimpleCountCollection hdf5CountCollection = new HDF5SimpleCountCollection(file);
            hdf5CountCollection.writeSampleName(SAMPLE_NAME_PATH, metadata.getSampleName());
            hdf5CountCollection.writeSequenceDictionary(SEQUENCE_DICTIONARY_PATH, metadata.getSequenceDictionary());
            hdf5CountCollection.writeIntervals(intervals);
            hdf5CountCollection.writeCounts(counts);
        }
    }

    private <T extends SimpleInterval> void writeIntervals(List<T> intervals) {
        HDF5Utils.writeIntervals(this.file, INTERVALS_GROUP_NAME, intervals);
    }

    private void writeSampleName(String path, String sampleName) {
        this.file.makeStringArray(path, new String[]{sampleName});
    }

    private void writeSequenceDictionary(String path, SAMSequenceDictionary sequenceDictionary) {
        StringWriter stringWriter = new StringWriter();
        new SAMTextHeaderCodec().encode((Writer)stringWriter, new SAMFileHeader(sequenceDictionary));
        this.file.makeStringArray(path, new String[]{stringWriter.toString()});
    }

    private void writeCounts(double[] counts) {
        this.file.makeDoubleMatrix(COUNTS_PATH, (double[][])new double[][]{counts});
    }
}

