/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.collections;

import java.io.File;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractSampleLocatableCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.IntegerCopyNumberSegment;
import org.broadinstitute.hellbender.tools.copynumber.gcnv.IntegerCopyNumberState;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;

public class IntegerCopyNumberSegmentCollection
extends AbstractSampleLocatableCollection<IntegerCopyNumberSegment> {
    static final Function<DataLine, IntegerCopyNumberSegment> INTEGER_COPY_NUMBER_SEGMENT_RECORD_DECODER = dataLine -> {
        String contig = dataLine.get(IntegerCopyNumberSegmentTableColumn.CONTIG);
        int start = dataLine.getInt(IntegerCopyNumberSegmentTableColumn.START);
        int end = dataLine.getInt(IntegerCopyNumberSegmentTableColumn.END);
        int numPoints = dataLine.getInt(IntegerCopyNumberSegmentTableColumn.NUM_POINTS);
        int callCopyNumber = dataLine.getInt(IntegerCopyNumberSegmentTableColumn.CALL_COPY_NUMBER);
        int baselineCopyNumber = dataLine.getInt(IntegerCopyNumberSegmentTableColumn.BASELINE_COPY_NUMBER);
        double qualitySomeCalled = dataLine.getDouble(IntegerCopyNumberSegmentTableColumn.QUALITY_SOME_CALLED);
        double qualityAllCalled = dataLine.getDouble(IntegerCopyNumberSegmentTableColumn.QUALITY_ALL_CALLED);
        double qualityStart = dataLine.getDouble(IntegerCopyNumberSegmentTableColumn.QUALITY_START);
        double qualityEnd = dataLine.getDouble(IntegerCopyNumberSegmentTableColumn.QUALITY_END);
        return new IntegerCopyNumberSegment(new SimpleInterval(contig, start, end), new IntegerCopyNumberState(callCopyNumber), new IntegerCopyNumberState(baselineCopyNumber), numPoints, qualitySomeCalled, qualityAllCalled, qualityStart, qualityEnd);
    };
    static final BiConsumer<IntegerCopyNumberSegment, DataLine> INTEGER_COPY_NUMBER_SEGMENT_RECORD_ENCODER = (integerCopyNumberSegment, dataLine) -> dataLine.append(integerCopyNumberSegment.getContig()).append(integerCopyNumberSegment.getStart()).append(integerCopyNumberSegment.getEnd()).append(integerCopyNumberSegment.getNumPoints()).append(integerCopyNumberSegment.getCallIntegerCopyNumberState().getCopyNumber()).append(integerCopyNumberSegment.getBaselineIntegerCopyNumberState().getCopyNumber()).append(IntegerCopyNumberSegmentCollection.formatDouble(integerCopyNumberSegment.getQualitySomeCalled())).append(IntegerCopyNumberSegmentCollection.formatDouble(integerCopyNumberSegment.getQualityAllCalled())).append(IntegerCopyNumberSegmentCollection.formatDouble(integerCopyNumberSegment.getQualityStart())).append(IntegerCopyNumberSegmentCollection.formatDouble(integerCopyNumberSegment.getQualityEnd()));

    public IntegerCopyNumberSegmentCollection(File inputFile) {
        super(inputFile, IntegerCopyNumberSegmentTableColumn.COLUMNS, INTEGER_COPY_NUMBER_SEGMENT_RECORD_DECODER, INTEGER_COPY_NUMBER_SEGMENT_RECORD_ENCODER);
    }

    public IntegerCopyNumberSegmentCollection(SampleLocatableMetadata metadata, List<IntegerCopyNumberSegment> integerCopyNumberSegmentList) {
        super(metadata, integerCopyNumberSegmentList, IntegerCopyNumberSegmentTableColumn.COLUMNS, INTEGER_COPY_NUMBER_SEGMENT_RECORD_DECODER, INTEGER_COPY_NUMBER_SEGMENT_RECORD_ENCODER);
    }

    static enum IntegerCopyNumberSegmentTableColumn {
        CONTIG,
        START,
        END,
        NUM_POINTS,
        CALL_COPY_NUMBER,
        BASELINE_COPY_NUMBER,
        QUALITY_SOME_CALLED,
        QUALITY_ALL_CALLED,
        QUALITY_START,
        QUALITY_END;

        static final TableColumnCollection COLUMNS;

        static {
            COLUMNS = new TableColumnCollection((Object[])IntegerCopyNumberSegmentTableColumn.values());
        }
    }
}

