/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.collections;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractRecordCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractSampleLocatableCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.LegacySegment;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;

public final class LegacySegmentCollection
extends AbstractSampleLocatableCollection<LegacySegment> {
    private static final Function<DataLine, LegacySegment> LEGACY_SEGMENT_DATA_LINE_TO_RECORD_FUNCTION = dataLine -> {
        String sampleName = dataLine.get(LegacySegmentTableColumn.SAMPLE.columnName);
        String contig = dataLine.get(LegacySegmentTableColumn.CHROMOSOME.columnName);
        int start = dataLine.getInt(LegacySegmentTableColumn.START.columnName);
        int end = dataLine.getInt(LegacySegmentTableColumn.END.columnName);
        int numProbes = dataLine.getInt(LegacySegmentTableColumn.NUM_PROBES.columnName);
        double segmentMean = dataLine.getDouble(LegacySegmentTableColumn.SEGMENT_MEAN.columnName);
        SimpleInterval interval = new SimpleInterval(contig, start, end);
        return new LegacySegment(sampleName, interval, numProbes, segmentMean);
    };
    private static final BiConsumer<LegacySegment, DataLine> LEGACY_SEGMENT_RECORD_AND_DATA_LINE_BI_CONSUMER = (LegacySegment2, dataLine) -> dataLine.append(LegacySegment2.getSampleName()).append(LegacySegment2.getContig()).append(LegacySegment2.getStart()).append(LegacySegment2.getEnd()).append(LegacySegment2.getNumProbes()).append(LegacySegmentCollection.formatDouble(LegacySegment2.getSegmentMean()));

    public LegacySegmentCollection(SampleLocatableMetadata metadata, List<LegacySegment> legacySegments) {
        super(metadata, legacySegments, LegacySegmentTableColumn.COLUMNS, LEGACY_SEGMENT_DATA_LINE_TO_RECORD_FUNCTION, LEGACY_SEGMENT_RECORD_AND_DATA_LINE_BI_CONSUMER);
    }

    @Override
    public void write(File outputFile) {
        Utils.nonNull(outputFile);
        try (AbstractRecordCollection.RecordCollectionWriter writer = new AbstractRecordCollection.RecordCollectionWriter(this, new FileWriter(outputFile));){
            writer.writeAllRecords(this.getRecords());
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile(outputFile, (Exception)e);
        }
    }

    static enum LegacySegmentTableColumn {
        SAMPLE("Sample"),
        CHROMOSOME("Chromosome"),
        START("Start"),
        END("End"),
        NUM_PROBES("Num_Probes"),
        SEGMENT_MEAN("Segment_Mean");

        private final String columnName;
        static final TableColumnCollection COLUMNS;

        private LegacySegmentTableColumn(String columnName) {
            this.columnName = columnName;
        }

        static {
            COLUMNS = new TableColumnCollection(Stream.of(LegacySegmentTableColumn.values()).map(c -> c.columnName).toArray());
        }
    }
}

