/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.collections;

import java.io.File;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractSampleLocatableCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.LinearCopyRatio;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;

public class LinearCopyRatioCollection
extends AbstractSampleLocatableCollection<LinearCopyRatio> {
    public LinearCopyRatioCollection(File inputFile) {
        super(inputFile, DenoisedLocatableCopyRatioTableColumn.COLUMNS, LinearCopyRatioCollection.getLinearCopyRatioRecordFromDataLineDecoder(), LinearCopyRatioCollection.getLinearCopyRatioRecordToDataLineEncoder());
    }

    public LinearCopyRatioCollection(SampleLocatableMetadata metadata, List<LinearCopyRatio> linearCopyRatioList) {
        super(metadata, linearCopyRatioList, DenoisedLocatableCopyRatioTableColumn.COLUMNS, LinearCopyRatioCollection.getLinearCopyRatioRecordFromDataLineDecoder(), LinearCopyRatioCollection.getLinearCopyRatioRecordToDataLineEncoder());
    }

    private static Function<DataLine, LinearCopyRatio> getLinearCopyRatioRecordFromDataLineDecoder() {
        return dataLine -> {
            try {
                String contig = dataLine.get(DenoisedLocatableCopyRatioTableColumn.CONTIG);
                int start = dataLine.getInt(DenoisedLocatableCopyRatioTableColumn.START);
                int end = dataLine.getInt(DenoisedLocatableCopyRatioTableColumn.END);
                double denoisedCopyRatio = dataLine.getDouble(DenoisedLocatableCopyRatioTableColumn.LINEAR_COPY_RATIO);
                return new LinearCopyRatio(new SimpleInterval(contig, start, end), denoisedCopyRatio);
            }
            catch (IllegalArgumentException ex) {
                throw new UserException.BadInput(String.format("Validation error occurred on line %d of the denoised copy ratio file : ", dataLine.getLineNumber()) + ex.getMessage());
            }
        };
    }

    private static BiConsumer<LinearCopyRatio, DataLine> getLinearCopyRatioRecordToDataLineEncoder() {
        return (linearCopyRatio, dataLine) -> dataLine.append(linearCopyRatio.getContig()).append(linearCopyRatio.getStart()).append(linearCopyRatio.getEnd()).append(linearCopyRatio.getLinearCopyRatio());
    }

    static enum DenoisedLocatableCopyRatioTableColumn {
        CONTIG,
        START,
        END,
        LINEAR_COPY_RATIO;

        static final TableColumnCollection COLUMNS;

        static {
            COLUMNS = new TableColumnCollection((Object[])DenoisedLocatableCopyRatioTableColumn.values());
        }
    }
}

