/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.collections;

import java.io.File;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractSampleLocatableCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.MultidimensionalSegment;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;

public final class MultidimensionalSegmentCollection
extends AbstractSampleLocatableCollection<MultidimensionalSegment> {
    private static final Function<DataLine, MultidimensionalSegment> MULTIDIMENSIONAL_SEGMENT_DATA_LINE_TO_RECORD_FUNCTION = dataLine -> {
        String contig = dataLine.get(MultidimensionalSegmentTableColumn.CONTIG);
        int start = dataLine.getInt(MultidimensionalSegmentTableColumn.START);
        int end = dataLine.getInt(MultidimensionalSegmentTableColumn.END);
        int numPointsCopyRatio = dataLine.getInt(MultidimensionalSegmentTableColumn.NUM_POINTS_COPY_RATIO);
        int numPointsAlleleFraction = dataLine.getInt(MultidimensionalSegmentTableColumn.NUM_POINTS_ALLELE_FRACTION);
        double meanLog2CopyRatio = dataLine.getDouble(MultidimensionalSegmentTableColumn.MEAN_LOG2_COPY_RATIO);
        SimpleInterval interval = new SimpleInterval(contig, start, end);
        return new MultidimensionalSegment(interval, numPointsCopyRatio, numPointsAlleleFraction, meanLog2CopyRatio);
    };
    private static final BiConsumer<MultidimensionalSegment, DataLine> MULTIDIMENSIONAL_SEGMENT_RECORD_AND_DATA_LINE_BI_CONSUMER = (alleleFractionSegment, dataLine) -> dataLine.append(alleleFractionSegment.getContig()).append(alleleFractionSegment.getStart()).append(alleleFractionSegment.getEnd()).append(alleleFractionSegment.getNumPointsCopyRatio()).append(alleleFractionSegment.getNumPointsAlleleFraction()).append(MultidimensionalSegmentCollection.formatDouble(alleleFractionSegment.getMeanLog2CopyRatio()));

    public MultidimensionalSegmentCollection(File inputFile) {
        super(inputFile, MultidimensionalSegmentTableColumn.COLUMNS, MULTIDIMENSIONAL_SEGMENT_DATA_LINE_TO_RECORD_FUNCTION, MULTIDIMENSIONAL_SEGMENT_RECORD_AND_DATA_LINE_BI_CONSUMER);
    }

    public MultidimensionalSegmentCollection(SampleLocatableMetadata metadata, List<MultidimensionalSegment> multidimensionalSegments) {
        super(metadata, multidimensionalSegments, MultidimensionalSegmentTableColumn.COLUMNS, MULTIDIMENSIONAL_SEGMENT_DATA_LINE_TO_RECORD_FUNCTION, MULTIDIMENSIONAL_SEGMENT_RECORD_AND_DATA_LINE_BI_CONSUMER);
    }

    static enum MultidimensionalSegmentTableColumn {
        CONTIG,
        START,
        END,
        NUM_POINTS_COPY_RATIO,
        NUM_POINTS_ALLELE_FRACTION,
        MEAN_LOG2_COPY_RATIO;

        static final TableColumnCollection COLUMNS;

        static {
            COLUMNS = new TableColumnCollection((Object[])MultidimensionalSegmentTableColumn.values());
        }
    }
}

