/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.collections;

import java.io.File;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractSampleRecordCollection;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;

public class NonLocatableDoubleCollection
extends AbstractSampleRecordCollection<Double> {
    private static final String defaultColumnName = "VALUE_0";

    public NonLocatableDoubleCollection(File inputFile) {
        super(inputFile, new TableColumnCollection(defaultColumnName), NonLocatableDoubleCollection.getDoubleRecordFromDataLineDecoder(), NonLocatableDoubleCollection.getDoubleRecordToDataLineEncoder());
    }

    private static Function<DataLine, Double> getDoubleRecordFromDataLineDecoder() {
        return dataLine -> {
            try {
                return dataLine.getDouble(defaultColumnName);
            }
            catch (IllegalArgumentException ex) {
                throw new UserException.BadInput(String.format("Validation error occurred on line %d of the denoised copy ratio file : ", dataLine.getLineNumber()) + ex.getMessage());
            }
        };
    }

    private static BiConsumer<Double, DataLine> getDoubleRecordToDataLineEncoder() {
        return (value, dataLine) -> dataLine.append((double)value);
    }
}

