/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.collections;

import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractSampleRecordCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleMetadata;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.mcmc.Decile;
import org.broadinstitute.hellbender.utils.mcmc.DecileCollection;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;

public final class ParameterDecileCollection<T extends Enum<T>>
extends AbstractSampleRecordCollection<Map.Entry<T, DecileCollection>> {
    private final Map<T, DecileCollection> parameterToDecileCollectionMap;

    private static DecileCollection parseDecilesFromDataLine(DataLine dataLine) {
        return new DecileCollection(Arrays.asList(dataLine.getDouble(ParameterTableColumn.POSTERIOR_10), dataLine.getDouble(ParameterTableColumn.POSTERIOR_20), dataLine.getDouble(ParameterTableColumn.POSTERIOR_30), dataLine.getDouble(ParameterTableColumn.POSTERIOR_40), dataLine.getDouble(ParameterTableColumn.POSTERIOR_50), dataLine.getDouble(ParameterTableColumn.POSTERIOR_60), dataLine.getDouble(ParameterTableColumn.POSTERIOR_70), dataLine.getDouble(ParameterTableColumn.POSTERIOR_80), dataLine.getDouble(ParameterTableColumn.POSTERIOR_90)));
    }

    private static void appendDecilesToDataLine(DataLine dataLine, DecileCollection deciles) {
        dataLine.append(ParameterDecileCollection.formatDouble(deciles.get(Decile.DECILE_10))).append(ParameterDecileCollection.formatDouble(deciles.get(Decile.DECILE_20))).append(ParameterDecileCollection.formatDouble(deciles.get(Decile.DECILE_30))).append(ParameterDecileCollection.formatDouble(deciles.get(Decile.DECILE_40))).append(ParameterDecileCollection.formatDouble(deciles.get(Decile.DECILE_50))).append(ParameterDecileCollection.formatDouble(deciles.get(Decile.DECILE_60))).append(ParameterDecileCollection.formatDouble(deciles.get(Decile.DECILE_70))).append(ParameterDecileCollection.formatDouble(deciles.get(Decile.DECILE_80))).append(ParameterDecileCollection.formatDouble(deciles.get(Decile.DECILE_90)));
    }

    public ParameterDecileCollection(SampleMetadata metadata, Map<T, DecileCollection> parameterToDecileCollectionMap, Class<T> parameterClass) {
        super(Utils.nonNull(metadata), new ArrayList<Map.Entry<T, DecileCollection>>(parameterToDecileCollectionMap.entrySet()), ParameterTableColumn.COLUMNS, (DataLine dataLine) -> {
            String parameterName = dataLine.get(ParameterTableColumn.PARAMETER_NAME);
            Object parameter = Enum.valueOf(Utils.nonNull(parameterClass), parameterName);
            DecileCollection deciles = ParameterDecileCollection.parseDecilesFromDataLine(dataLine);
            return new AbstractMap.SimpleEntry(parameter, deciles);
        }, (RECORD record, DataLine dataLine) -> {
            Enum parameter = (Enum)record.getKey();
            DecileCollection deciles = (DecileCollection)record.getValue();
            ParameterDecileCollection.appendDecilesToDataLine(dataLine.append(parameter.toString()), deciles);
        });
        this.parameterToDecileCollectionMap = parameterToDecileCollectionMap;
    }

    public ParameterDecileCollection(File file, Class<T> parameterClass) {
        super(Utils.nonNull(file), ParameterTableColumn.COLUMNS, dataLine -> {
            String parameterName = dataLine.get(ParameterTableColumn.PARAMETER_NAME);
            Object parameter = Enum.valueOf(Utils.nonNull(parameterClass), parameterName);
            DecileCollection deciles = ParameterDecileCollection.parseDecilesFromDataLine(dataLine);
            return new AbstractMap.SimpleEntry(parameter, deciles);
        }, (record, dataLine) -> {
            Enum parameter = (Enum)record.getKey();
            DecileCollection deciles = (DecileCollection)record.getValue();
            dataLine.append(parameter.toString());
            ParameterDecileCollection.appendDecilesToDataLine(dataLine, deciles);
        });
        this.parameterToDecileCollectionMap = this.getRecords().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public DecileCollection getDeciles(T parameter) {
        return this.parameterToDecileCollectionMap.get(parameter);
    }

    static enum ParameterTableColumn {
        PARAMETER_NAME,
        POSTERIOR_10,
        POSTERIOR_20,
        POSTERIOR_30,
        POSTERIOR_40,
        POSTERIOR_50,
        POSTERIOR_60,
        POSTERIOR_70,
        POSTERIOR_80,
        POSTERIOR_90;

        static final TableColumnCollection COLUMNS;

        static {
            COLUMNS = new TableColumnCollection((Object[])ParameterTableColumn.values());
        }
    }
}

