/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.collections;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.broadinstitute.hdf5.HDF5File;
import org.broadinstitute.hellbender.engine.FeatureDataSource;
import org.broadinstitute.hellbender.tools.copynumber.arguments.CopyNumberArgumentValidationUtils;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractSampleLocatableCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.HDF5SimpleCountCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.SimpleCount;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.codecs.copynumber.SimpleCountCodec;
import org.broadinstitute.hellbender.utils.config.ConfigFactory;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;

public final class SimpleCountCollection
extends AbstractSampleLocatableCollection<SimpleCount> {
    private static final int DEFAULT_FEATURE_QUERY_LOOKAHEAD_IN_BP = 1000000;
    private static final Function<DataLine, SimpleCount> SIMPLE_COUNT_RECORD_FROM_DATA_LINE_DECODER = dataLine -> {
        String contig = dataLine.get(SimpleCountTableColumn.CONTIG);
        int start = dataLine.getInt(SimpleCountTableColumn.START);
        int end = dataLine.getInt(SimpleCountTableColumn.END);
        int count = dataLine.getInt(SimpleCountTableColumn.COUNT);
        SimpleInterval interval = new SimpleInterval(contig, start, end);
        return new SimpleCount(interval, count);
    };
    private static final BiConsumer<SimpleCount, DataLine> SIMPLE_COUNT_RECORD_TO_DATA_LINE_ENCODER = (simpleCount, dataLine) -> dataLine.append(simpleCount.getInterval().getContig()).append(simpleCount.getInterval().getStart()).append(simpleCount.getInterval().getEnd()).append(simpleCount.getCount());

    private SimpleCountCollection(File inputFile) {
        super(inputFile, SimpleCountTableColumn.COLUMNS, SIMPLE_COUNT_RECORD_FROM_DATA_LINE_DECODER, SIMPLE_COUNT_RECORD_TO_DATA_LINE_ENCODER);
    }

    public SimpleCountCollection(SampleLocatableMetadata metadata, List<SimpleCount> simpleCounts) {
        super(metadata, simpleCounts, SimpleCountTableColumn.COLUMNS, SIMPLE_COUNT_RECORD_FROM_DATA_LINE_DECODER, SIMPLE_COUNT_RECORD_TO_DATA_LINE_ENCODER);
    }

    public static SimpleCountCollection read(File file) {
        IOUtils.canReadFile(file);
        return SimpleCountCollection.readAndSubset(file, null);
    }

    public static SimpleCountCollection readAndSubset(File file, Set<SimpleInterval> intervalSubset) {
        SimpleCountCollection simpleCounts;
        IOUtils.canReadFile(file);
        SimpleCountCollection simpleCountCollection = simpleCounts = IOUtils.isHDF5File(file.toPath()) ? SimpleCountCollection.readHDF5(new HDF5File(file)) : SimpleCountCollection.readTSV(file);
        if (intervalSubset == null || intervalSubset.isEmpty()) {
            return simpleCounts;
        }
        return new SimpleCountCollection((SampleLocatableMetadata)simpleCounts.getMetadata(), simpleCounts.getRecords().stream().filter(c -> intervalSubset.contains(c.getInterval())).collect(Collectors.toList()));
    }

    private static SimpleCountCollection readTSV(File file) {
        IOUtils.canReadFile(file);
        return new SimpleCountCollection(file);
    }

    private static SimpleCountCollection readHDF5(HDF5File file) {
        Utils.nonNull(file);
        HDF5SimpleCountCollection hdf5CountCollection = new HDF5SimpleCountCollection(file);
        SampleLocatableMetadata metadata = hdf5CountCollection.getMetadata();
        List<SimpleInterval> intervals = hdf5CountCollection.getIntervals();
        double[] counts = hdf5CountCollection.getCounts().getRow(0);
        List<SimpleCount> simpleCounts = IntStream.range(0, intervals.size()).mapToObj(i -> new SimpleCount((SimpleInterval)intervals.get(i), (int)counts[i])).collect(Collectors.toList());
        return new SimpleCountCollection(metadata, simpleCounts);
    }

    public static SimpleCountCollection readFromGCS(String path) {
        IOUtils.assertFileIsReadable(IOUtils.getPath(path));
        Utils.validate(BucketUtils.isGcsUrl(path), "Read-count path must be a Google Cloud Storage URL.");
        Utils.validate(new SimpleCountCodec().canDecode(path), String.format("Read-count file extension must be one of the following: [%s]", String.join((CharSequence)",", SimpleCountCodec.SIMPLE_COUNT_CODEC_EXTENSIONS)));
        return SimpleCountCollection.readOverlappingSubsetFromGCS(path, null);
    }

    public static SimpleCountCollection readOverlappingSubsetFromGCS(String path, List<SimpleInterval> overlapIntervals) {
        IOUtils.assertFileIsReadable(IOUtils.getPath(path));
        Utils.validate(BucketUtils.isGcsUrl(path), "Read-count path must be a Google Cloud Storage URL.");
        Utils.validate(new SimpleCountCodec().canDecode(path), String.format("Read-count file extension must be one of the following: [%s]", String.join((CharSequence)",", SimpleCountCodec.SIMPLE_COUNT_CODEC_EXTENSIONS)));
        FeatureDataSource simpleCountsFeatureDataSource = new FeatureDataSource(path, path, 1000000, SimpleCount.class, ConfigFactory.getInstance().getGATKConfig().cloudPrefetchBuffer(), ConfigFactory.getInstance().getGATKConfig().cloudIndexPrefetchBuffer());
        SampleLocatableMetadata metadata = (SampleLocatableMetadata)simpleCountsFeatureDataSource.getHeader();
        if (overlapIntervals != null) {
            CopyNumberArgumentValidationUtils.validateIntervals(overlapIntervals, metadata.getSequenceDictionary());
        }
        simpleCountsFeatureDataSource.setIntervalsForTraversal(overlapIntervals);
        ImmutableList simpleCounts = ImmutableList.copyOf(simpleCountsFeatureDataSource.iterator());
        return new SimpleCountCollection(metadata, (List<SimpleCount>)simpleCounts);
    }

    public void writeHDF5(File file) {
        Utils.nonNull(file);
        HDF5SimpleCountCollection.write(file, (SampleLocatableMetadata)this.getMetadata(), this.getIntervals(), this.getCounts());
    }

    public double[] getCounts() {
        return this.getRecords().stream().mapToDouble(SimpleCount::getCount).toArray();
    }

    public static enum SimpleCountTableColumn {
        CONTIG,
        START,
        END,
        COUNT;

        public static final TableColumnCollection COLUMNS;

        static {
            COLUMNS = new TableColumnCollection((Object[])SimpleCountTableColumn.values());
        }
    }
}

