/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.collections;

import java.io.File;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AbstractLocatableCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.LocatableMetadata;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;

public final class SimpleIntervalCollection
extends AbstractLocatableCollection<LocatableMetadata, SimpleInterval> {
    private static final Function<DataLine, SimpleInterval> SIMPLE_INTERVAL_RECORD_FROM_DATA_LINE_DECODER = dataLine -> {
        String contig = dataLine.get(SimpleIntervalTableColumn.CONTIG);
        int start = dataLine.getInt(SimpleIntervalTableColumn.START);
        int end = dataLine.getInt(SimpleIntervalTableColumn.END);
        return new SimpleInterval(contig, start, end);
    };
    private static final BiConsumer<SimpleInterval, DataLine> SIMPLE_INTERVAL_RECORD_TO_DATA_LINE_ENCODER = (simpleInterval, dataLine) -> dataLine.append(simpleInterval.getContig()).append(simpleInterval.getStart()).append(simpleInterval.getEnd());

    public SimpleIntervalCollection(File inputFile) {
        super(inputFile, SimpleIntervalTableColumn.COLUMNS, SIMPLE_INTERVAL_RECORD_FROM_DATA_LINE_DECODER, SIMPLE_INTERVAL_RECORD_TO_DATA_LINE_ENCODER);
    }

    public SimpleIntervalCollection(LocatableMetadata metadata, List<SimpleInterval> simpleIntervals) {
        super(metadata, simpleIntervals, SimpleIntervalTableColumn.COLUMNS, SIMPLE_INTERVAL_RECORD_FROM_DATA_LINE_DECODER, SIMPLE_INTERVAL_RECORD_TO_DATA_LINE_ENCODER);
    }

    static enum SimpleIntervalTableColumn {
        CONTIG,
        START,
        END;

        static final TableColumnCollection COLUMNS;

        static {
            COLUMNS = new TableColumnCollection((Object[])SimpleIntervalTableColumn.values());
        }
    }
}

