/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.metadata;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.Metadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SimpleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SimpleSampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SimpleSampleMetadata;
import org.broadinstitute.hellbender.utils.Utils;

public final class MetadataUtils {
    static final String GATK_CNV_READ_GROUP_ID = "GATKCopyNumber";

    private MetadataUtils() {
    }

    public static String readSampleName(SAMFileHeader header) {
        Utils.nonNull(header);
        Utils.nonEmpty(header.getReadGroups(), "The input header does not contain any read groups.  Cannot determine a sample name.");
        List sampleNames = header.getReadGroups().stream().map(SAMReadGroupRecord::getSample).distinct().collect(Collectors.toList());
        if (sampleNames.size() > 1) {
            throw new IllegalArgumentException(String.format("The input header contains more than one unique sample name: %s", StringUtils.join(sampleNames, (String)", ")));
        }
        if (sampleNames.isEmpty()) {
            throw new IllegalArgumentException("The input header does not contain a sample name.");
        }
        return (String)sampleNames.get(0);
    }

    public static <T extends Metadata> T fromHeader(SAMFileHeader header, Metadata.Type metadataType) {
        Utils.nonNull(header);
        Utils.nonNull(metadataType);
        switch (metadataType) {
            case SAMPLE: {
                return (T)new SimpleSampleMetadata(MetadataUtils.readSampleName(header));
            }
            case LOCATABLE: {
                return (T)new SimpleLocatableMetadata(header.getSequenceDictionary());
            }
            case SAMPLE_LOCATABLE: {
                return (T)new SimpleSampleLocatableMetadata(MetadataUtils.readSampleName(header), header.getSequenceDictionary());
            }
        }
        throw new GATKException.ShouldNeverReachHereException("Encountered unknown Metadata.Type.");
    }
}

