/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.metadata;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.LocatableMetadata;
import org.broadinstitute.hellbender.utils.Utils;

public class SimpleLocatableMetadata
implements LocatableMetadata {
    private final SAMSequenceDictionary sequenceDictionary;

    public SimpleLocatableMetadata(SAMSequenceDictionary sequenceDictionary) {
        this.sequenceDictionary = Utils.nonNull(sequenceDictionary);
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleLocatableMetadata that = (SimpleLocatableMetadata)o;
        return this.sequenceDictionary.isSameDictionary(that.sequenceDictionary);
    }

    public int hashCode() {
        return this.sequenceDictionary.hashCode();
    }

    public String toString() {
        return "SimpleLocatableMetadata{sequenceDictionary=" + this.sequenceDictionary + '}';
    }

    @Override
    public SAMFileHeader toHeader() {
        return new SAMFileHeader(this.sequenceDictionary);
    }
}

