/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.metadata;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.LocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SimpleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SimpleSampleMetadata;
import org.broadinstitute.hellbender.utils.Utils;

public class SimpleSampleLocatableMetadata
implements SampleLocatableMetadata {
    private final SampleMetadata sampleMetadata;
    private final LocatableMetadata locatableMetadata;

    public SimpleSampleLocatableMetadata(String sampleName, SAMSequenceDictionary sequenceDictionary) {
        Utils.nonEmpty(sampleName);
        Utils.nonNull(sequenceDictionary);
        this.sampleMetadata = new SimpleSampleMetadata(sampleName);
        this.locatableMetadata = new SimpleLocatableMetadata(sequenceDictionary);
    }

    @Override
    public String getSampleName() {
        return this.sampleMetadata.getSampleName();
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        return this.locatableMetadata.getSequenceDictionary();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleSampleLocatableMetadata that = (SimpleSampleLocatableMetadata)o;
        return this.sampleMetadata.equals(that.sampleMetadata) && this.locatableMetadata.equals(that.locatableMetadata);
    }

    public int hashCode() {
        int result = this.sampleMetadata.hashCode();
        result = 31 * result + this.locatableMetadata.hashCode();
        return result;
    }

    public String toString() {
        return "SimpleSampleLocatableMetadata{sampleMetadata=" + this.sampleMetadata + ", locatableMetadata=" + this.locatableMetadata + '}';
    }

    @Override
    public SAMFileHeader toHeader() {
        SAMFileHeader header = this.sampleMetadata.toHeader();
        header.setSequenceDictionary(this.locatableMetadata.getSequenceDictionary());
        return header;
    }
}

