/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.metadata;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import java.io.Serializable;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleMetadata;
import org.broadinstitute.hellbender.utils.Utils;

public class SimpleSampleMetadata
implements SampleMetadata,
Serializable {
    private static final long serialVersionUID = 0L;
    private final String sampleName;

    public SimpleSampleMetadata(String sampleName) {
        this.sampleName = Utils.nonEmpty(sampleName);
    }

    @Override
    public String getSampleName() {
        return this.sampleName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleSampleMetadata that = (SimpleSampleMetadata)o;
        return this.sampleName.equals(that.sampleName);
    }

    public int hashCode() {
        return this.sampleName.hashCode();
    }

    public String toString() {
        return "SimpleSampleMetadata{sampleName='" + this.sampleName + '\'' + '}';
    }

    @Override
    public SAMFileHeader toHeader() {
        SAMReadGroupRecord readGroupRecord = new SAMReadGroupRecord("GATKCopyNumber");
        readGroupRecord.setAttribute("SM", this.sampleName);
        SAMFileHeader header = new SAMFileHeader();
        header.addReadGroup(readGroupRecord);
        return header;
    }
}

