/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.records;

import htsjdk.samtools.util.Locatable;
import java.util.List;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.AllelicCount;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public class AlleleFractionSegment
implements Locatable {
    private final SimpleInterval interval;
    private final int numPoints;

    public AlleleFractionSegment(SimpleInterval interval, int numPoints) {
        Utils.nonNull(interval);
        ParamUtils.isPositiveOrZero(numPoints, "Number of points must be non-negative.");
        this.interval = interval;
        this.numPoints = numPoints;
    }

    public AlleleFractionSegment(SimpleInterval interval, List<AllelicCount> allelicCounts) {
        Utils.nonNull(interval);
        Utils.nonNull(allelicCounts);
        this.interval = interval;
        this.numPoints = allelicCounts.size();
    }

    public String getContig() {
        return this.interval.getContig();
    }

    public int getStart() {
        return this.interval.getStart();
    }

    public int getEnd() {
        return this.interval.getEnd();
    }

    public SimpleInterval getInterval() {
        return this.interval;
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlleleFractionSegment that = (AlleleFractionSegment)o;
        return this.numPoints == that.numPoints && this.interval.equals(that.interval);
    }

    public int hashCode() {
        int result = this.interval.hashCode();
        result = 31 * result + this.numPoints;
        return result;
    }

    public String toString() {
        return "AlleleFractionSegment{interval=" + this.interval + ", numPoints=" + this.numPoints + '}';
    }
}

