/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.records;

import htsjdk.samtools.util.Locatable;
import org.broadinstitute.hellbender.utils.Nucleotide;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public class AllelicCount
implements Locatable {
    private final SimpleInterval interval;
    private final int refReadCount;
    private final int altReadCount;
    private final Nucleotide refNucleotide;
    private final Nucleotide altNucleotide;

    public AllelicCount(SimpleInterval interval, int refReadCount, int altReadCount, Nucleotide refNucleotide, Nucleotide altNucleotide) {
        this.interval = Utils.nonNull(interval);
        this.refReadCount = ParamUtils.isPositiveOrZero(refReadCount, "Can't construct AllelicCount with negative read counts.");
        this.altReadCount = ParamUtils.isPositiveOrZero(altReadCount, "Can't construct AllelicCount with negative read counts.");
        this.refNucleotide = Utils.nonNull(refNucleotide);
        this.altNucleotide = Utils.nonNull(altNucleotide);
    }

    public AllelicCount(SimpleInterval interval, int refReadCount, int altReadCount) {
        this(interval, refReadCount, altReadCount, Nucleotide.N, Nucleotide.N);
    }

    public String getContig() {
        return this.interval.getContig();
    }

    public int getStart() {
        return this.interval.getStart();
    }

    public int getEnd() {
        return this.interval.getEnd();
    }

    public SimpleInterval getInterval() {
        return this.interval;
    }

    public int getRefReadCount() {
        return this.refReadCount;
    }

    public int getAltReadCount() {
        return this.altReadCount;
    }

    public Nucleotide getRefNucleotide() {
        return this.refNucleotide;
    }

    public Nucleotide getAltNucleotide() {
        return this.altNucleotide;
    }

    public int getTotalReadCount() {
        return this.altReadCount + this.refReadCount;
    }

    public double getAlternateAlleleFraction() {
        return this.getTotalReadCount() == 0 ? 0.0 : (double)this.altReadCount / (double)this.getTotalReadCount();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AllelicCount)) {
            return false;
        }
        AllelicCount count = (AllelicCount)o;
        return this.interval.equals(count.interval) && this.refReadCount == count.refReadCount && this.altReadCount == count.altReadCount && (this.refNucleotide == Nucleotide.N && this.altNucleotide == Nucleotide.N || count.refNucleotide == Nucleotide.N && count.altNucleotide == Nucleotide.N || this.refNucleotide == count.refNucleotide && this.altNucleotide == count.altNucleotide);
    }

    public int hashCode() {
        int result = this.interval.hashCode();
        result = 31 * result + this.refReadCount;
        result = 31 * result + this.altReadCount;
        return result;
    }

    public String toString() {
        return "AllelicCount{interval=" + this.interval + ", refReadCount=" + this.refReadCount + ", altReadCount=" + this.altReadCount + ", refNucleotide=" + (Object)((Object)this.refNucleotide) + ", altNucleotide=" + (Object)((Object)this.altNucleotide) + '}';
    }
}

