/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.records;

import htsjdk.samtools.util.Locatable;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.annotation.AnnotationMap;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

public class AnnotatedInterval
implements Locatable {
    private final SimpleInterval interval;
    private final AnnotationMap annotationMap;

    public AnnotatedInterval(SimpleInterval interval, AnnotationMap annotationMap) {
        this.interval = Utils.nonNull(interval);
        this.annotationMap = Utils.nonNull(annotationMap);
    }

    public String getContig() {
        return this.interval.getContig();
    }

    public int getStart() {
        return this.interval.getStart();
    }

    public int getEnd() {
        return this.interval.getEnd();
    }

    public SimpleInterval getInterval() {
        return this.interval;
    }

    public AnnotationMap getAnnotationMap() {
        return this.annotationMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotatedInterval that = (AnnotatedInterval)o;
        return this.interval.equals(that.interval) && this.annotationMap.equals(that.annotationMap);
    }

    public int hashCode() {
        int result = this.interval.hashCode();
        result = 31 * result + this.annotationMap.hashCode();
        return result;
    }

    public String toString() {
        return "AnnotatedInterval{interval=" + this.interval + ", annotationMap=" + this.annotationMap + '}';
    }
}

