/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.records;

import org.broadinstitute.hellbender.tools.copynumber.formats.records.CopyRatioSegment;
import org.broadinstitute.hellbender.utils.Utils;

public class CalledCopyRatioSegment
extends CopyRatioSegment {
    private final Call call;

    public CalledCopyRatioSegment(CopyRatioSegment segment, Call call) {
        super(segment.getInterval(), segment.getNumPoints(), segment.getMeanLog2CopyRatio());
        this.call = Utils.nonNull(call);
    }

    public Call getCall() {
        return this.call;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CalledCopyRatioSegment that = (CalledCopyRatioSegment)o;
        return this.call == that.call;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.call.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "CalledCopyRatioSegment{interval=" + this.getInterval() + ", numPoints=" + this.getNumPoints() + ", meanLog2CopyRatio=" + this.getMeanLog2CopyRatio() + ", call=" + (Object)((Object)this.call) + '}';
    }

    public static enum Call {
        AMPLIFICATION("+"),
        DELETION("-"),
        NEUTRAL("0");

        private final String outputString;

        private Call(String outputString) {
            this.outputString = outputString;
        }

        public String getOutputString() {
            return this.outputString;
        }
    }
}

