/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.records;

import org.broadinstitute.hellbender.tools.copynumber.formats.records.CalledCopyRatioSegment;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.LegacySegment;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

public class CalledLegacySegment
extends LegacySegment {
    private final CalledCopyRatioSegment.Call call;

    public CalledLegacySegment(String sampleName, SimpleInterval interval, int numProbes, double segmentMean, CalledCopyRatioSegment.Call call) {
        super(sampleName, interval, numProbes, segmentMean);
        Utils.nonNull(call, "Cannot initialize a called legacy segment with a null call.");
        this.call = call;
    }

    public CalledCopyRatioSegment.Call getCall() {
        return this.call;
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CalledLegacySegment that = (CalledLegacySegment)o;
        return this.call == that.call;
    }

    @Override
    public final int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.call.hashCode();
        return result;
    }

    @Override
    public final String toString() {
        return "CalledLegacySegment{interval=" + this.getInterval() + ", numPoints=" + this.getNumProbes() + ", meanLog2CopyRatio=" + this.getSegmentMean() + ", call=" + (Object)((Object)this.call) + '}';
    }
}

