/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.records;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.math3.util.FastMath;
import org.broadinstitute.hellbender.tools.copynumber.gcnv.IntegerCopyNumberState;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;

public class CopyNumberPosteriorDistribution {
    private final Map<IntegerCopyNumberState, Double> copyNumberPosteriorDistribution;
    private final List<IntegerCopyNumberState> integerCopyNumberStateList;
    private static final double ERROR_TOLERANCE = 1.0E-4;

    public CopyNumberPosteriorDistribution(Map<IntegerCopyNumberState, Double> copyNumberPosteriorDistribution) {
        this.copyNumberPosteriorDistribution = Utils.nonNull(copyNumberPosteriorDistribution);
        this.integerCopyNumberStateList = copyNumberPosteriorDistribution.keySet().stream().sorted().collect(Collectors.toList());
        double probabilitySum = this.copyNumberPosteriorDistribution.values().stream().mapToDouble(FastMath::exp).sum();
        if (MathUtils.compareDoubles(probabilitySum, 1.0, 1.0E-4) != 0) {
            throw new IllegalArgumentException("Posterior probabilities for at at least one posterior record do not sum up to one.");
        }
    }

    public double getCopyNumberPosterior(IntegerCopyNumberState integerCopyNumberState) {
        return this.copyNumberPosteriorDistribution.get(integerCopyNumberState);
    }

    public List<IntegerCopyNumberState> getIntegerCopyNumberStateList() {
        return this.integerCopyNumberStateList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CopyNumberPosteriorDistribution that = (CopyNumberPosteriorDistribution)o;
        return this.copyNumberPosteriorDistribution != null ? this.copyNumberPosteriorDistribution.equals(that.copyNumberPosteriorDistribution) : that.copyNumberPosteriorDistribution == null;
    }

    public int hashCode() {
        return this.copyNumberPosteriorDistribution != null ? this.copyNumberPosteriorDistribution.hashCode() : 0;
    }

    public String toString() {
        return "CopyNumberPosteriorDistribution{copyNumberPosteriorDistribution=" + this.copyNumberPosteriorDistribution + '}';
    }
}

