/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.records;

import htsjdk.samtools.util.Locatable;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

public class CopyRatio
implements Locatable {
    private final SimpleInterval interval;
    private final double log2CopyRatioValue;

    public CopyRatio(SimpleInterval interval, double log2CopyRatioValue) {
        Utils.nonNull(interval);
        Utils.validateArg(Double.isFinite(log2CopyRatioValue), "Non-finite log2 copy ratio is not allowed.");
        this.interval = interval;
        this.log2CopyRatioValue = log2CopyRatioValue;
    }

    public String getContig() {
        return this.interval.getContig();
    }

    public int getStart() {
        return this.interval.getStart();
    }

    public int getEnd() {
        return this.interval.getEnd();
    }

    public SimpleInterval getInterval() {
        return this.interval;
    }

    public double getLog2CopyRatioValue() {
        return this.log2CopyRatioValue;
    }

    public SimpleInterval getMidpoint() {
        int midPoint = (this.getStart() + this.getEnd()) / 2;
        return new SimpleInterval(this.interval.getContig(), midPoint, midPoint);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CopyRatio copyRatio = (CopyRatio)o;
        return Double.compare(copyRatio.log2CopyRatioValue, this.log2CopyRatioValue) == 0 && this.interval.equals(copyRatio.interval);
    }

    public int hashCode() {
        int result = this.interval.hashCode();
        long temp = Double.doubleToLongBits(this.log2CopyRatioValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "CopyRatio{interval=" + this.interval + ", log2CopyRatioValue=" + this.log2CopyRatioValue + '}';
    }
}

