/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.records;

import htsjdk.samtools.util.Locatable;
import java.util.List;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.CopyRatio;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public class CopyRatioSegment
implements Locatable {
    private final SimpleInterval interval;
    private final int numPoints;
    private final double meanLog2CopyRatio;

    public CopyRatioSegment(SimpleInterval interval, int numPoints, double meanLog2CopyRatio) {
        Utils.nonNull(interval);
        ParamUtils.isPositiveOrZero(numPoints, "Number of copy-ratio points must be non-negative.");
        this.interval = interval;
        this.numPoints = numPoints;
        this.meanLog2CopyRatio = meanLog2CopyRatio;
    }

    public CopyRatioSegment(SimpleInterval interval, List<CopyRatio> denoisedLog2CopyRatios) {
        Utils.nonNull(interval);
        Utils.nonNull(denoisedLog2CopyRatios);
        this.interval = interval;
        this.numPoints = denoisedLog2CopyRatios.size();
        this.meanLog2CopyRatio = denoisedLog2CopyRatios.stream().mapToDouble(CopyRatio::getLog2CopyRatioValue).average().orElse(Double.NaN);
    }

    public String getContig() {
        return this.interval.getContig();
    }

    public int getStart() {
        return this.interval.getStart();
    }

    public int getEnd() {
        return this.interval.getEnd();
    }

    public SimpleInterval getInterval() {
        return this.interval;
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public double getMeanLog2CopyRatio() {
        return this.meanLog2CopyRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CopyRatioSegment that = (CopyRatioSegment)o;
        return this.numPoints == that.numPoints && Double.compare(that.meanLog2CopyRatio, this.meanLog2CopyRatio) == 0 && this.interval.equals(that.interval);
    }

    public int hashCode() {
        int result = this.interval.hashCode();
        result = 31 * result + this.numPoints;
        long temp = Double.doubleToLongBits(this.meanLog2CopyRatio);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "CopyRatioSegment{interval=" + this.interval + ", numPoints=" + this.numPoints + ", meanLog2CopyRatio=" + this.meanLog2CopyRatio + '}';
    }
}

