/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.records;

import java.util.LinkedHashMap;
import org.broadinstitute.hellbender.utils.Utils;

public final class CoveragePerContig {
    private final String sampleName;
    private final LinkedHashMap<String, Integer> coveragePerContig;

    public CoveragePerContig(String sampleName, LinkedHashMap<String, Integer> coveragePerContig) {
        this.sampleName = Utils.nonEmpty(sampleName);
        this.coveragePerContig = Utils.nonNull(coveragePerContig);
    }

    public String getSampleName() {
        return this.sampleName;
    }

    public int getCoverage(String contig) {
        return this.coveragePerContig.get(contig);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoveragePerContig that = (CoveragePerContig)o;
        return this.sampleName.equals(that.sampleName) && this.coveragePerContig.equals(that.coveragePerContig);
    }

    public int hashCode() {
        int result = this.sampleName.hashCode();
        result = 31 * result + this.coveragePerContig.hashCode();
        return result;
    }
}

