/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.records;

import htsjdk.samtools.util.Locatable;
import org.broadinstitute.hellbender.tools.copynumber.gcnv.IntegerCopyNumberState;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public class IntegerCopyNumberSegment
implements Locatable {
    private final SimpleInterval interval;
    private final IntegerCopyNumberState callIntegerCopyNumberState;
    private final IntegerCopyNumberState baselineIntegerCopyNumberState;
    private final int numPoints;
    private final double qualitySomeCalled;
    private final double qualityAllCalled;
    private final double qualityStart;
    private final double qualityEnd;

    public IntegerCopyNumberSegment(SimpleInterval interval, IntegerCopyNumberState callIntegerCopyNumberState, IntegerCopyNumberState baselineIntegerCopyNumberState, int numPoints, double qualitySomeCalled, double qualityAllCalled, double qualityStart, double qualityEnd) {
        this.interval = Utils.nonNull(interval, "The interval for the segment must be non-null.");
        this.callIntegerCopyNumberState = Utils.nonNull(callIntegerCopyNumberState, "The call integer copy-number state for the segment must be non-null.");
        this.baselineIntegerCopyNumberState = Utils.nonNull(baselineIntegerCopyNumberState, "The baseline integer copy-number state for the segment must be non-null.");
        this.numPoints = ParamUtils.isPositive(numPoints, "Number of points in the segment must be positive.");
        this.qualitySomeCalled = ParamUtils.isPositiveOrZero(qualitySomeCalled, "The phred-scaled quality of \"some points called\" must be non-negative.");
        this.qualityAllCalled = ParamUtils.isPositiveOrZero(qualityAllCalled, "The phred-scaled quality of \"all points called\" must be non-negative.");
        this.qualityStart = ParamUtils.isPositiveOrZero(qualityStart, "The phred-scaled quality of \"segment start\" must be non-negative.");
        this.qualityEnd = ParamUtils.isPositiveOrZero(qualityEnd, "The phred-scaled quality of \"segment end\" must be non-negative.");
    }

    public String getContig() {
        return this.interval.getContig();
    }

    public int getStart() {
        return this.interval.getStart();
    }

    public int getEnd() {
        return this.interval.getEnd();
    }

    public SimpleInterval getInterval() {
        return this.interval;
    }

    public IntegerCopyNumberState getCallIntegerCopyNumberState() {
        return this.callIntegerCopyNumberState;
    }

    public IntegerCopyNumberState getBaselineIntegerCopyNumberState() {
        return this.baselineIntegerCopyNumberState;
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public double getQualitySomeCalled() {
        return this.qualitySomeCalled;
    }

    public double getQualityAllCalled() {
        return this.qualityAllCalled;
    }

    public double getQualityStart() {
        return this.qualityStart;
    }

    public double getQualityEnd() {
        return this.qualityEnd;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        IntegerCopyNumberSegment that = (IntegerCopyNumberSegment)other;
        return this.numPoints == that.numPoints && Double.compare(that.qualitySomeCalled, this.qualitySomeCalled) == 0 && Double.compare(that.qualityAllCalled, this.qualityAllCalled) == 0 && Double.compare(that.qualityStart, this.qualityStart) == 0 && Double.compare(that.qualityEnd, this.qualityEnd) == 0 && this.interval.equals(that.interval) && this.callIntegerCopyNumberState.equals(that.callIntegerCopyNumberState) && this.baselineIntegerCopyNumberState.equals(that.baselineIntegerCopyNumberState);
    }

    public int hashCode() {
        int result = this.interval.hashCode();
        result = 31 * result + this.callIntegerCopyNumberState.hashCode();
        result = 31 * result + this.baselineIntegerCopyNumberState.hashCode();
        result = 31 * result + this.numPoints;
        long temp = Double.doubleToLongBits(this.qualitySomeCalled);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.qualityAllCalled);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.qualityStart);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.qualityEnd);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "IntegerCopyNumberSegment{interval=" + this.interval + ", callIntegerCopyNumberState=" + this.callIntegerCopyNumberState + ", baselineIntegerCopyNumberState=" + this.baselineIntegerCopyNumberState + ", numPoints=" + this.numPoints + ", qualitySomeCalled=" + this.qualitySomeCalled + ", qualityAllCalled=" + this.qualityAllCalled + ", qualityStart=" + this.qualityStart + ", qualityEnd=" + this.qualityEnd + '}';
    }
}

