/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.records;

import htsjdk.samtools.util.Locatable;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public class LegacySegment
implements Locatable {
    private final String sampleName;
    private final SimpleInterval interval;
    private final int numProbes;
    private final double segmentMean;

    public LegacySegment(String sampleName, SimpleInterval interval, int numProbes, double segmentMean) {
        Utils.nonEmpty(sampleName);
        Utils.nonNull(interval);
        ParamUtils.isPositiveOrZero(numProbes, "Number of probes must be non-negative.");
        this.sampleName = sampleName;
        this.interval = interval;
        this.numProbes = numProbes;
        this.segmentMean = segmentMean;
    }

    public String getSampleName() {
        return this.sampleName;
    }

    public String getContig() {
        return this.interval.getContig();
    }

    public int getStart() {
        return this.interval.getStart();
    }

    public int getEnd() {
        return this.interval.getEnd();
    }

    public SimpleInterval getInterval() {
        return this.interval;
    }

    public int getNumProbes() {
        return this.numProbes;
    }

    public double getSegmentMean() {
        return this.segmentMean;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegacySegment that = (LegacySegment)o;
        return this.numProbes == that.numProbes && Double.compare(that.segmentMean, this.segmentMean) == 0 && this.sampleName.equals(that.sampleName) && this.interval.equals(that.interval);
    }

    public int hashCode() {
        int result = this.sampleName.hashCode();
        result = 31 * result + this.interval.hashCode();
        result = 31 * result + this.numProbes;
        long temp = Double.doubleToLongBits(this.segmentMean);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "LegacySegment{sampleName='" + this.sampleName + '\'' + ", interval=" + this.interval + ", numProbes=" + this.numProbes + ", segmentMean=" + this.segmentMean + '}';
    }
}

