/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.records;

import htsjdk.samtools.util.Locatable;
import java.util.Objects;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

public class LinearCopyRatio
implements Locatable {
    private final SimpleInterval interval;
    private final double linearCopyRatio;

    public LinearCopyRatio(SimpleInterval interval, double linearCopyRatio) {
        this.interval = Utils.nonNull(interval, "The interval must be non-null.");
        this.linearCopyRatio = linearCopyRatio;
    }

    public String getContig() {
        return this.interval.getContig();
    }

    public int getStart() {
        return this.interval.getStart();
    }

    public int getEnd() {
        return this.interval.getEnd();
    }

    public SimpleInterval getInterval() {
        return this.interval;
    }

    public double getLinearCopyRatio() {
        return this.linearCopyRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinearCopyRatio that = (LinearCopyRatio)o;
        return Double.compare(that.linearCopyRatio, this.linearCopyRatio) == 0 && this.interval.equals(that.interval);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.linearCopyRatio);
    }
}

