/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.records;

import htsjdk.samtools.util.Locatable;
import java.util.List;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.mcmc.Decile;
import org.broadinstitute.hellbender.utils.mcmc.DecileCollection;

public class ModeledSegment
implements Locatable {
    private final SimpleInterval interval;
    private final int numPointsCopyRatio;
    private final int numPointsAlleleFraction;
    private final SimplePosteriorSummary log2CopyRatioSimplePosteriorSummary;
    private final SimplePosteriorSummary minorAlleleFractionSimplePosteriorSummary;

    public ModeledSegment(SimpleInterval interval, int numPointsCopyRatio, int numPointsAlleleFraction, SimplePosteriorSummary log2CopyRatioSimplePosteriorSummary, SimplePosteriorSummary minorAlleleFractionSimplePosteriorSummary) {
        Utils.validateArg(numPointsCopyRatio > 0 || numPointsAlleleFraction > 0, String.format("Number of copy-ratio points or number of allele-fraction points must be positive: %s", interval));
        this.interval = Utils.nonNull(interval);
        this.numPointsCopyRatio = numPointsCopyRatio;
        this.numPointsAlleleFraction = numPointsAlleleFraction;
        this.log2CopyRatioSimplePosteriorSummary = Utils.nonNull(log2CopyRatioSimplePosteriorSummary);
        this.minorAlleleFractionSimplePosteriorSummary = Utils.nonNull(minorAlleleFractionSimplePosteriorSummary);
    }

    public String getContig() {
        return this.interval.getContig();
    }

    public int getStart() {
        return this.interval.getStart();
    }

    public int getEnd() {
        return this.interval.getEnd();
    }

    public SimpleInterval getInterval() {
        return this.interval;
    }

    public int getNumPointsCopyRatio() {
        return this.numPointsCopyRatio;
    }

    public int getNumPointsAlleleFraction() {
        return this.numPointsAlleleFraction;
    }

    public SimplePosteriorSummary getLog2CopyRatioSimplePosteriorSummary() {
        return this.log2CopyRatioSimplePosteriorSummary;
    }

    public SimplePosteriorSummary getMinorAlleleFractionSimplePosteriorSummary() {
        return this.minorAlleleFractionSimplePosteriorSummary;
    }

    public static final class SimplePosteriorSummary {
        private final double decile10;
        private final double decile50;
        private final double decile90;

        public SimplePosteriorSummary(double decile10, double decile50, double decile90) {
            this.decile10 = decile10;
            this.decile50 = decile50;
            this.decile90 = decile90;
        }

        public SimplePosteriorSummary(List<Double> samples) {
            DecileCollection deciles = new DecileCollection(samples);
            this.decile10 = deciles.get(Decile.DECILE_10);
            this.decile50 = deciles.get(Decile.DECILE_50);
            this.decile90 = deciles.get(Decile.DECILE_90);
        }

        public double getDecile10() {
            return this.decile10;
        }

        public double getDecile50() {
            return this.decile50;
        }

        public double getDecile90() {
            return this.decile90;
        }

        public String toString() {
            return "SimplePosteriorSummary{decile10=" + this.decile10 + ", decile50=" + this.decile50 + ", decile90=" + this.decile90 + '}';
        }
    }
}

