/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.records;

import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.OverlapDetector;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.AllelicCount;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.CopyRatio;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.CopyRatioSegment;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

public class MultidimensionalSegment
implements Locatable {
    private final SimpleInterval interval;
    private final int numPointsCopyRatio;
    private final int numPointsAlleleFraction;
    private final double meanLog2CopyRatio;

    public MultidimensionalSegment(SimpleInterval interval, int numPointsCopyRatio, int numPointsAlleleFraction, double meanLog2CopyRatio) {
        Utils.nonNull(interval);
        Utils.validateArg(numPointsCopyRatio > 0 || numPointsAlleleFraction > 0, String.format("Number of copy-ratio points or number of allele-fraction points must be positive: %s", interval));
        this.interval = interval;
        this.numPointsCopyRatio = numPointsCopyRatio;
        this.numPointsAlleleFraction = numPointsAlleleFraction;
        this.meanLog2CopyRatio = meanLog2CopyRatio;
    }

    public MultidimensionalSegment(SimpleInterval interval, List<CopyRatio> denoisedLog2CopyRatios, List<AllelicCount> allelicCounts) {
        Utils.nonNull(interval);
        Utils.nonNull(denoisedLog2CopyRatios);
        Utils.nonNull(allelicCounts);
        this.interval = interval;
        this.numPointsCopyRatio = denoisedLog2CopyRatios.size();
        this.numPointsAlleleFraction = allelicCounts.size();
        this.meanLog2CopyRatio = new CopyRatioSegment(interval, denoisedLog2CopyRatios).getMeanLog2CopyRatio();
    }

    public MultidimensionalSegment(SimpleInterval interval, Comparator<Locatable> comparator, OverlapDetector<CopyRatio> copyRatioMidpointOverlapDetector, OverlapDetector<AllelicCount> allelicCountOverlapDetector) {
        this(interval, copyRatioMidpointOverlapDetector.getOverlaps((Locatable)interval).stream().sorted(comparator).collect(Collectors.toList()), allelicCountOverlapDetector.getOverlaps((Locatable)interval).stream().sorted(comparator).collect(Collectors.toList()));
    }

    public String getContig() {
        return this.interval.getContig();
    }

    public int getStart() {
        return this.interval.getStart();
    }

    public int getEnd() {
        return this.interval.getEnd();
    }

    public SimpleInterval getInterval() {
        return this.interval;
    }

    public int getNumPointsCopyRatio() {
        return this.numPointsCopyRatio;
    }

    public int getNumPointsAlleleFraction() {
        return this.numPointsAlleleFraction;
    }

    public double getMeanLog2CopyRatio() {
        return this.meanLog2CopyRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultidimensionalSegment that = (MultidimensionalSegment)o;
        return this.numPointsCopyRatio == that.numPointsCopyRatio && this.numPointsAlleleFraction == that.numPointsAlleleFraction && Double.compare(that.meanLog2CopyRatio, this.meanLog2CopyRatio) == 0 && this.interval.equals(that.interval);
    }

    public int hashCode() {
        int result = this.interval.hashCode();
        result = 31 * result + this.numPointsCopyRatio;
        result = 31 * result + this.numPointsAlleleFraction;
        long temp = Double.doubleToLongBits(this.meanLog2CopyRatio);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "MultidimensionalSegment{interval=" + this.interval + ", numPointsCopyRatio=" + this.numPointsCopyRatio + ", numPointsAlleleFraction=" + this.numPointsAlleleFraction + ", meanLog2CopyRatio=" + this.meanLog2CopyRatio + '}';
    }
}

